/*
 * przykad prostego programu czcego si z serwerem i wysyajcego
 * jedn wiadomo.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "libgadu.h"

int main(int argc, char **argv)
{
	struct gg_session *sess;
	struct gg_event *e;
	struct gg_login_params p;

	if (argc < 5) {
		fprintf(stderr, "uycie: %s <mjnumerek> <mojehaso> <numerek> <wiadomo>\n", argv[0]);
		return 1;
	}

	gg_debug_level = 255;

	memset(&p, 0, sizeof(p));
	p.uin = atoi(argv[1]);
	p.password = argv[2];
	
	if (!(sess = gg_login(&p))) {
		printf("Nie udao si poczy: %s\n", strerror(errno));
		gg_free_session(sess);
		return 1;
	}

	printf("Poczono.\n");

	if (gg_send_message(sess, GG_CLASS_MSG, atoi(argv[3]), argv[4]) == -1) {
		printf("Poczenie przerwane: %s\n", strerror(errno));
		gg_free_session(sess);
		return 1;
	}

	/* ponisz cz mona ola, ale poczekajmy na potwierdzenie */

	while (1) {
		if (!(e = gg_watch_fd(sess))) {
			printf("Poczenie przerwane: %s\n", strerror(errno));
			gg_logoff(sess);
			gg_free_session(sess);
			return 1;
		}

		if (e->type == GG_EVENT_ACK) {
			printf("Wysano.\n");
			gg_free_event(e);
			break;
		}

		gg_free_event(e);
	}

	gg_logoff(sess);
	gg_free_session(sess);

	return 0;
}
