/* $Id: themes.c,v 1.64 2002/05/25 22:05:41 wojtekka Exp $ */

/*
 *  (C) Copyright 2001-2002 Wojtek Kaniewski <wojtekka@irc.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#ifndef _AIX
#  include <string.h>
#endif
#include <stdarg.h>
#include <limits.h>
#include <readline.h>
#include "stuff.h"
#include "dynstuff.h"
#include "themes.h"
#include "config.h"

char *prompt_cache = NULL, *prompt2_cache = NULL, *error_cache = NULL, *timestamp_cache = NULL;
char *readline_prompt = NULL, *readline_prompt_away = NULL, *readline_prompt_invisible = NULL;

int no_prompt_cache = 0;

struct list *formats = NULL;

/*
 * find_format()
 *
 * odnajduje warto danego formatu. jeli nie znajdzie, zwraca pusty cig,
 * eby nie musie uwaa na adne null-references.
 *
 *  - name.
 */
char *find_format(char *name)
{
	struct list *l;
	
	for (l = formats; l; l = l->next) {
		struct format *f = l->data;

		if (!strcasecmp(f->name, name))
			return f->value;
	}
	
	return "";
}

/*
 * va_format_string()
 *
 * formatuje zgodnie z podanymi parametrami cig znakw.
 *
 *  - format - warto, nie nazwa formatu,
 *  - ap - argumenty.
 */
char *va_format_string(char *format, va_list ap)
{
	static int dont_resolve = 0;
	struct string *buf;
	char *p, *args[9];
	int i;
	// void **args = (void**) ap;

	for (i = 0; i < 9; i++)
		args[i] = NULL;

	for (i = 0; i < 9; i++) {
		if (!(args[i] = va_arg(ap, char*)))
			break;
	}

	if (!dont_resolve) {
		dont_resolve = 1;
		if (no_prompt_cache) {
			/* zawsze czytaj */
			timestamp_cache = find_format("timestamp");
			prompt_cache = format_string(find_format("prompt"));
			prompt2_cache = format_string(find_format("prompt2"));
			error_cache = format_string(find_format("error"));
		} else {
			/* tylko jeli nie s keszowanie */
			if (!timestamp_cache)
				timestamp_cache = find_format("timestamp");
			if (!prompt_cache)
				prompt_cache = format_string(find_format("prompt"));
			if (!prompt2_cache)
				prompt2_cache = format_string(find_format("prompt2"));
			if (!error_cache)
				error_cache = format_string(find_format("error"));
		}
		dont_resolve = 0;
	}
	
	if (!(buf = string_init("")))
		return NULL;

	p = format;
	
	while (*p) {
		if (*p == '%') {
			int fill_before, fill_after, fill_soft, fill_length;
			char fill_char;

			p++;
			if (!*p)
				break;
			if (*p == '%')
				string_append_c(buf, '%');
			if (*p == '>')
				string_append(buf, prompt_cache);
			if (*p == ')')
				string_append(buf, prompt2_cache);
			if (*p == '!')
				string_append(buf, error_cache);
			if (*p == '#')
				string_append(buf, timestamp(timestamp_cache));
			if (config_display_color) {
				if (*p == 'k')
					string_append(buf, "\033[0;30m");
				if (*p == 'K')
					string_append(buf, "\033[1;30m");
				if (*p == 'l')
					string_append(buf, "\033[40m");
				if (*p == 'r')
					string_append(buf, "\033[0;31m");
				if (*p == 'R')
					string_append(buf, "\033[1;31m");
				if (*p == 's')
					string_append(buf, "\033[41m");
				if (*p == 'g')
					string_append(buf, "\033[0;32m");
				if (*p == 'G')
					string_append(buf, "\033[1;32m");
				if (*p == 'h')
					string_append(buf, "\033[42m");
				if (*p == 'y')
					string_append(buf, "\033[0;33m");
				if (*p == 'Y')
					string_append(buf, "\033[1;33m");
				if (*p == 'z')
					string_append(buf, "\033[43m");
				if (*p == 'b')
					string_append(buf, "\033[0;34m");
				if (*p == 'B')
					string_append(buf, "\033[1;34m");
				if (*p == 'e')
					string_append(buf, "\033[44m");
				if (*p == 'm' || *p == 'p')
					string_append(buf, "\033[0;35m");
				if (*p == 'M' || *p == 'P')
					string_append(buf, "\033[1;35m");
				if (*p == 'q')
					string_append(buf, "\033[45m");
				if (*p == 'c')
					string_append(buf, "\033[0;36m");
				if (*p == 'C')
					string_append(buf, "\033[1;36m");
				if (*p == 'd')
					string_append(buf, "\033[46m");
				if (*p == 'w')
					string_append(buf, "\033[0;37m");
				if (*p == 'W')
					string_append(buf, "\033[1;37m");
				if (*p == 'x')
					string_append(buf, "\033[47m");
				if (*p == 'i')
					string_append(buf, "\033[5m");
				if (*p == 'n')
					string_append(buf, "\033[0m");
			}

			if (*p == '@') {
				char *str = (char*) args[*(p + 1) - '1'];

				if (str) {
					char *q = str + strlen(str) - 1;

					while (q >= str && !isalpha(*q))
						q--;

					if (*q == 'a')
						string_append(buf, "a");
					else
						string_append(buf, "y");
				}
				p += 2;
				continue;
			}

			fill_before = 0;
			fill_after = 0;
			fill_length = 0;
			fill_char = ' ';
			fill_soft = 1;

			if (*p == '[' || *p == '(') {
				fill_soft = (*p == '(');

				p++;
				fill_char = ' ';

				if (*p == '.') {
					fill_char = '0';
					p++;
				} else if (*p == ',') {
					fill_char = '.';
					p++;
				} else if (*p == '_') {
					fill_char = '_';
					p++;
				}

				fill_length = strtol(p, &p, 0);
				if (fill_length > 0)
					fill_after = 1;
				else {
					fill_length = -fill_length;
					fill_before = 1;
				}
				p++;
			}

			if (*p >= '1' && *p <= '9') {
				char *str = (char*) args[*p - '1'];
				int i, len;

				if (!str)
					str = "";
				len = strlen(str);

				if (fill_length) {
					if (len >= fill_length) {
						if (!fill_soft)
							len = fill_length;
						fill_length = 0;
					} else
						fill_length -= len;
				}

				if (fill_before)
					for (i = 0; i < fill_length; i++)
						string_append_c(buf, fill_char);

				string_append_n(buf, str, len);

				if (fill_after) 
					for (i = 0; i < fill_length; i++)
						string_append_c(buf, fill_char);

			}
		} else
			string_append_c(buf, *p);

		p++;
	}

	return string_free(buf, 0);
}

/*
 * format_string()
 *
 * j.w. tyle e nie potrzeba dawa mu va_list, a wystarcz zwyke parametry.
 *
 *  - format... - j.w.,
 */
char *format_string(char *format, ...)
{
	va_list ap;
	char *tmp;
	
	va_start(ap, format);
	tmp = va_format_string(format, ap);
	va_end(ap);

	return tmp;
}

/*
 * my_printf()
 *
 * drukuje na stdout tekst, biorc pod uwag nazw, nie warto formatu.
 * parametry takie jak zdefiniowano. pierwszy to %1, drugi to %2.
 */
void my_printf(char *theme, ...)
{
	va_list ap;
	char *tmp, *p;
	
	va_start(ap, theme);
	tmp = va_format_string(find_format(theme), ap);
	
	if (my_printf_lines != -2)
		my_puts("%s", (tmp) ? tmp : "");

	if (my_printf_lines >= 0) {
		for (p = tmp; *p; p++)
			if (*p == '\n')
				my_printf_lines++;

		if (my_printf_lines > screen_lines - 2) {
			char *tmp, *prompt = find_format("readline_more");
			
			in_readline = 1;
#ifdef HAVE_RL_SET_PROMPT
		        rl_set_prompt(prompt);
#endif				
			my_printf_lines = -1;
			tmp = readline(prompt);
			in_readline = 0;
			if (tmp) {
				free(tmp);
				my_printf_lines = 0;
			} else {
				printf("\n");
				my_printf_lines = -2;
			}
			printf("\033[A\033[K");		/* XXX */
		}
	}
	
	free(tmp);
	va_end(ap);
}

/*
 * reset_theme_cache()
 *
 * usuwa cache'owane prompty. przydaje si przy zmianie theme'u.
 */
#ifdef __GNUC__
inline void reset_theme_cache()
#else
void reset_theme_cache()
#endif
{
	free(prompt_cache);
	free(prompt2_cache);
	free(error_cache);
	
	prompt_cache = prompt2_cache = error_cache = NULL;
	readline_prompt = readline_prompt_away = readline_prompt_invisible = NULL;
	timestamp_cache = NULL;
}

/*
 * add_format()
 *
 * dodaje dan formatk do listy.
 *
 *  - name - nazwa,
 *  - value - warto,
 *  - replace - jeli znajdzie, to zostawia (=0) lub zamienia (=1).
 */
int add_format(char *name, char *value, int replace)
{
	struct format f;
	struct list *l;

	if (!strcasecmp(name, "no_prompt_cache")) {
		no_prompt_cache = 1;
		return 0;
	}
	
	for (l = formats; l; l = l->next) {
		struct format *g = l->data;

		if (!strcasecmp(name, g->name)) {
			if (replace) {
				free(g->value);
				g->value = strdup(value);
			}

			return 0;
		}
	}

	f.name = strdup(name);
	f.value = strdup(value);
	list_add(&formats, &f, sizeof(f));
	
	return 0;
}

/*
 * del_format()
 *
 * usuwa formatk o danej nazwie.
 *
 *  - name.
 */
int del_format(char *name)
{
	struct list *l;

	for (l = formats; l; l = l->next) {
		struct format *f = l->data;

		if (!strcasecmp(f->name, name)) {
			free(f->value);
			free(f->name);
			list_remove(&formats, f, 1);
		
			return 0;
		}
	}

        return -1;
}

/*
 * try_open() // funkcja wewntrzna
 *
 * prbuje otworzy plik, jeli jeszcze nie jest otwarty.
 *
 *  - prevfd - deskryptor z poprzedniego wywoania,
 *  - prefix - cieka,
 *  - filename - nazwa pliku.
 */
static FILE *try_open(FILE *prevfd, char *prefix, char *filename)
{
	char buf[PATH_MAX];
	FILE *f;

	if (prevfd)
		return prevfd;

	if (prefix)
		snprintf(buf, sizeof(buf) - 1, "%s/%s", prefix, filename);
	else
		snprintf(buf, sizeof(buf) - 1, "%s", filename);

	if ((f = fopen(buf, "r")))
		return f;

	if (prefix)
		snprintf(buf, sizeof(buf) - 1, "%s/%s.theme", prefix, filename);
	else
		snprintf(buf, sizeof(buf) - 1, "%s.theme", filename);

	if ((f = fopen(buf, "r")))
		return f;

	return NULL;
}

/*
 * read_theme()
 *
 * wczytuje opis wygldu z podanego pliku. 
 *
 *  - filename.
 */
int read_theme(char *filename, int replace)
{
        char *buf, *tmp;
        FILE *f = NULL;

        if (!filename) {
                filename = prepare_path("default.theme");
		if (!filename || !(f = fopen(filename, "r")))
			return -1;
        } else {
		if (strchr(filename, '/'))
			f = try_open(NULL, NULL, filename);
		else {
			f = try_open(NULL, THEMES_DIR, filename);
			tmp = prepare_path("");
			f = try_open(f, tmp, filename);
			tmp = prepare_path("themes");
			f = try_open(f, tmp, filename);
		}
		if (!f)
			return -1;
	}

        while ((buf = read_file(f))) {
                char *value, *p;

                if (buf[0] == '#') {
			free(buf);
                        continue;
		}

                if (!(value = strchr(buf, ' '))) {
			free(buf);
                        continue;
		}

		*value++ = 0;

		for (p = value; *p; p++) {
			if (*p == '\\') {
				if (!*(p + 1))
					break;
				if (*(p + 1) == 'n')
					*p = '\n';
				memmove(p + 1, p + 2, strlen(p + 1));
			}
		}

		if (buf[0] == '-')
			del_format(buf + 1);
		else
			add_format(buf, value, replace);

		free(buf);
        }

        fclose(f);

        return 0;
}

/*
 * init_theme()
 *
 * ustawia domylne wartoci formatek.
 */
void init_theme()
{
	add_format("prompt", "%g-%G>%g-%n", 1);
	add_format("prompt2", "%c-%C>%c-%n", 1);
	add_format("error", "%r-%R>%r-%n", 1);
	add_format("timestamp", "%H:%M", 1);
	add_format("readline_prompt", "% ", 1);
	add_format("readline_prompt_away", "/ ", 1);
	add_format("readline_prompt_invisible", ". ", 1);
	add_format("readline_prompt_query", "%1> ", 1);
	add_format("readline_more", "-- wcinij enter by kontynuowa --", 1);

	add_format("known_user", "%W%1%n/%2", 1);
	add_format("unknown_user", "%W%1%n", 1);
	add_format("user_not_given", "Nie podany uytkownik!\n", 1);
	
	add_format("none", "%1\n", 1);
	add_format("not_enough_params", "%! Za mao parametrw\n", 1);
	add_format("invalid_uin", "%! Nieprawidowy numer uytkownika\n", 1);
	add_format("user_added", "%> Uytkownik %1 zosta dopisany do listy kontaktw\n", 1);
	add_format("error_adding", "%! Wystpi bd podczas dopisywania uytkownika\n", 1);
	add_format("away", "%> Zmieniono stan na zajty %c(%C%#%c)%n\n", 1);
	add_format("away_descr", "%> Zmieniono stan na zajty: %1 %c(%C%#%c)%n\n", 1);
	add_format("back", "%> Zmieniono stan na dostpny %c(%C%#%c)%n\n", 1);
	add_format("back_descr", "%> Zmieniono stan na dostpny: %1 %c(%C%#%c)%n\n", 1);
	add_format("invisible", "%> Zmieniono stan na niewidoczny %c(%C%#%c)%n\n", 1);
	add_format("invisible_descr", "%> Zmieniono stan na niewidoczny: %1 %c(%C%#%c)%n\n", 1);
	add_format("user_not_found", "%! Nie znaleziono uytkownika %W%1%n\n", 1);
	add_format("user_deleted", "%> Uytkownik %1 zosta usunity z listy kontaktw\n", 1);
	add_format("error_deleting", "%! Wystpi bd podczas usuwania uytkownika\n", 1);
	add_format("user_exists", "%! Uytkownik %W%1%n ju istnieje w licie kontaktw\n", 1);
	add_format("help", "%> %1%2 - %3\n", 1);
	add_format("help_more", "%) %1\n", 1);
	add_format("generic", "%> %1\n", 1);
	add_format("ignored_list", "%> %1\n", 1);
	add_format("ignored_list_empty", "%! Lista ignorowanych uytkownikw jest pusta\n", 1);
	add_format("ignored_added", "%> Uytkownika %W%1%n dodano do listy ignorowanych\n", 1);
	add_format("error_adding_ignored", "%! Dodanie do listy ignorowanych nie powiodo si\n", 1);
	add_format("ignored_deleted", "%> Uytkownika %W%1%n usunito z listy ignorowanych\n", 1);
	add_format("error_not_ignored", "%! Uytkownik %W%1%n nie jest ignorowany\n", 1);
	add_format("list_empty", "%! Lista kontaktw jest pusta\n", 1);
	add_format("list_avail", "%> %1 %Y(dostpn%@2)%n %b%3:%4%n\n", 1);
	add_format("list_avail_descr", "%> %1 %Y(dostpn%@2: %n%5%Y)%n %b%3:%4%n\n", 1);
	add_format("list_busy", "%> %1 %G(zajt%@2)%n %b%3:%4%n\n", 1);
	add_format("list_busy_descr", "%> %1 %G(zajt%@2: %n%5%G)%n %b%3:%4%n\n", 1);
	add_format("list_not_avail", "%> %1 %r(niedostpn%@2)%n\n", 1);
	add_format("list_not_avail_descr", "%> %1 %r(niedostpn%@1: %n%5%r)%n\n", 1);
	add_format("list_invisible", "%> %1 %c(niewidoczn%@2)%n %b%3:%4%n\n", 1);
	add_format("list_unknown", "%> %1\n", 1);
	add_format("saved", "%> Zapisano ustawienia\n", 1);
	add_format("error_saving", "%! Podczas zapisu ustawie wystpi bd\n", 1);
	add_format("quit", "%> Papa\n", 1);
	add_format("quit_descr", "%> Papa: %1\n", 1);
	add_format("message_header", "%g.-- %n%1 %c(%C%#%c/%2)%n %g--- -- -\n", 1);
	add_format("message_footer", "%g`----- ---- --- -- -%n\n", 1);
	add_format("message_line", "%g|%n %1\n", 1);
	add_format("message_line_width", "75", 1);
	add_format("chat_header", "%c.-- %n%1 %c(%C%#%c/%2)%n %c--- -- -\n", 1);
	add_format("chat_footer", "%c`----- ---- --- -- -%n\n", 1);
	add_format("chat_line", "%c|%n %1\n", 1);
	add_format("chat_line_width", "75", 1);
	add_format("sysmsg_header", "%m.-- %WWiadomo systemowa %m--- -- -\n", 1);
	add_format("sysmsg_line", "%m|%n %1\n", 1);
	add_format("sysmsg_line_width", "75", 1);
	add_format("sysmsg_footer", "%m`----- ---- --- -- -%n\n", 1);	
	add_format("ack_queued", "%> Wiadomo do %1 zostanie dostarczona pniej %c(%C%#%c)%n\n", 1);
	add_format("ack_delivered", "%> Wiadomo do %1 zostaa dostarczona %c(%C%#%c)%n\n", 1);
	add_format("status_avail", "%> %1 jest dostpn%@2 %c(%C%#%c)%n\n", 1);
	add_format("status_avail_descr", "%> %1 jest dostpn%@2: %3 %c(%C%#%c)%n\n", 1);
	add_format("status_busy", "%> %1 jest zajt%@2 %c(%C%#%c)%n\n", 1);
	add_format("status_busy_descr", "%> %1 jest zajt%@2: %3 %c(%C%#%c)%n\n", 1);
	add_format("status_not_avail", "%> %1 jest niedostpn%@2 %c(%C%#%c)%n\n", 1);
	add_format("status_not_avail_descr", "%> %1 jest niedostpn%@2: %3 %c(%C%#%c)%n\n", 1);
	add_format("status_invisible", "%> %1 jest niewidoczn%@2 %c(%C%#%c)%n\n", 1);
	add_format("status_invisible_descr", "%> %1 jest niewidoczn%@2: %3 %c(%C%#%c)%n\n", 1);
	add_format("conn_broken", "%! Serwer zerwa poczenie: %1 %c(%C%#%c)%n\n", 1);
	add_format("auto_away", "%> Automagicznie zmieniono stan na zajty po %1 nieaktywnoci %c(%C%#%c)%n\n", 1);
	add_format("auto_away_descr", "%> Automagicznie zmieniono stan na zajty po %1 nieaktywnoci %c(%C%#%c)%n: %2\n", 1);
	add_format("welcome", "%> %WEKG-%1%n (Eksperymentalny Klient Gadu-gadu)\n%> (C) Copyright 2001, 2002 Wojtek Kaniewski <wojtekka@irc.pl> i inni\n%> Program jest rozprowadzany na zasadach licencji GPL\n%> %RPrzed uyciem przeczytaj ulotk (polecenie ,,help'' lub F1)%n\n\n", 1);
	add_format("error_reading_config", "%! Nie mona odczyta pliku konfiguracyjnego: %1\n", 1);
	add_format("offline_mode", "%! Tryb off-line\n", 1);
	add_format("connecting", "%> cz si z serwerem...\n", 1);
	add_format("conn_failed", "%! Poczenie nie udao si: %1\n", 1);
	add_format("conn_stopped", "%! Przerwano czenie\n", 1);
	add_format("conn_timeout", "%! Przekroczono limit czasu operacji czenia z serwerem\n", 1);
	add_format("disconn_warning", "%! Serwer zerwa poczenie\n", 1); 
	add_format("connected", "%> Poczono %c(%C%#%c)%n\n", 1);
	add_format("disconnected", "%> Rozczono %c(%C%#%c)%n\n", 1);
	add_format("disconnected_descr", "%> Rozczono %c(%C%#%c): %1%n\n", 1);
	add_format("theme_loaded", "%> Wczytano opis wygldu o nazwie %W%1%n\n", 1);
	add_format("theme_default", "%> Ustawiono domylny opis wygldu\n", 1);
	add_format("error_loading_theme", "%! Wystpi bd podczas adowania opisu wygldu: %1\n", 1);
	add_format("not_connected", "%! Brak poczenia z serwerem\n", 1);
	add_format("variable", "%> %1 = %2\n", 1);
	add_format("variable_not_found", "%! Nieznana zmienna: %1\n", 1);
	add_format("variable_invalid", "%! Nieprawidowa warto zmiennej\n", 1);
	add_format("not_implemented", "%! Tej funkcji jeszcze nie ma\n", 1);
	add_format("no_config", "%! Niekompletna konfiguracja. Wpisz:\n%!   %Wset uin <numerek-gg>%n\n%!   %Wset password <haso>%n\n%!   %Wsave%n\n%! Nastpnie wydaj polecenie:\n%!   %Wconnect%n\n%! Jeli nie masz swojego numerka, wpisz:\n%!   %Wregister <e-mail> <haso>%n\n\n", 1);
	
	add_format("register", "%> Rejestracja poprawna. Wygrany numerek: %W%1%n\n", 1);
	add_format("register_failed", "%! Bd podczas rejestracji\n", 1);
	add_format("register_pending", "%! Rejestracja w toku\n", 1);
	add_format("register_timeout", "%! Przekroczono limit czasu operacji szukania\n", 1);
	
	add_format("remind", "%> Haso zostao wysane\n", 1);
	add_format("remind_failed", "%! Bd podczas wysyania hasa\n", 1);
	add_format("remind_timeout", "%! Przekroczono limit czasu operacji wysania hasa\n", 1);
	
	add_format("passwd", "%> Haso zostao zmienione\n", 1);
	add_format("passwd_failed", "%! Bd podczas zmiany hasa\n", 1);
	add_format("passwd_timeout", "%! Przekroczono limit czasu operacji zmiany hasa\n", 1);
	
	add_format("change", "%> Informacje w katalogu publicznym zostay zmienione\n", 1);
	add_format("change_failed", "%! Bd podczas zmiany informacji w katalogu publicznym\n", 1);
	add_format("change_timeout", "%! Przekroczono limit czasu operacji zmiany katalogu publicznego\n", 1);
	
	add_format("sms_msg", "EKG: msg %1 %# >> %2", 1);
	add_format("sms_chat", "EKG: chat %1 %# >> %2", 1);
	add_format("sms_error", "%! Bd wysyania SMS\n", 1);
	add_format("sms_unknown", "%! Uytkownik %1 nie ma podanego numeru komrki\n", 1);
	add_format("sms_sent", "%> SMS do %W%1%n zosta wysany\n", 1);
	add_format("sms_failed", "%! SMS do %W%1%n nie zosta wysany\n", 1);

	add_format("already_connected", "%! Klient jest ju poczony\n", 1);
	add_format("during_connect", "%! czenie trwa\n", 1);
	add_format("search_failed", "%! Wystpi bd podczas szukania: %1\n", 1);
	add_format("search_timeout", "%! Przekroczono limit czasu operacji szukania\n", 1);
	add_format("search_not_found", "%! Nie znaleziono\n", 1);
	add_format("unknown_command", "%! Nieznane polecenie: %W%1%n\n", 1);
	add_format("already_searching", "%! Szukanie trwa. Poczekaj, albo uyj %Wfind -stop%n\n", 1);

	/* 1 uin, 2 name, 3 nick, 4 city, 5 born, 6 gender, 7 active */

	add_format("search_results_multi_active", "%G!%n", 1);
	add_format("search_results_multi_inactive", " ", 1);
	add_format("search_results_multi_unknown", "-", 1);
	add_format("search_results_multi_female", "k", 1);
	add_format("search_results_multi_male", "m", 1);
	add_format("search_results_multi", "%7 %[-10]1 %K/%n %[12]3 %K/%n %6 %K/%n %[20]2 %K/%n %[4]5 %K/%n %[16]4\n", 1);

	add_format("search_results_single_active", "%G(aktywn%@1)%n", 1);
	add_format("search_results_single_inactive", "%r(nieaktywn%@1)%n", 1);
	add_format("search_results_single_unknown", "%W-%n", 1);
	add_format("search_results_single_female", "%Mkobieta%n", 1);
	add_format("search_results_single_male", "%Cmczyzna%n", 1);
	add_format("search_results_single", "%) Nick: %W%3%n\n%) Numerek: %W%1%n\n%) Imi i nazwisko: %W%2%n\n%) Miejscowo: %W%4%n\n%) Rok urodzenia: %W%5%n\n%) Pe: %6\n", 1);

	add_format("search_stopped", "%) Zatrzymano szukanie\n", 1);

	add_format("process", "%> %(-5)1 %2\n", 1);
	add_format("no_processes", "%! Nie ma dziaajcych procesw\n", 1);
	add_format("process_exit", "%> Proces %1 (%2) zakoczy dziaanie z wynikiem %3\n", 1);

	add_format("modify_done", "%> Zmieniono wpis w licie kontaktw\n", 1);
	add_format("user_info", "%) Pseudonim: %W%3%n\n%) Numer: %W%7%n\n%) Stan: %8\n%) Imi i nazwisko: %W%1 %2%n\n%) Alias: %W%4%n\n%) Numer telefonu: %W%5%n\n%) Grupy: %W%6%n\n", 1);
	add_format("user_info_avail", "%Ydostpn%@1%n", 1);
	add_format("user_info_avail_descr", "%Ydostpn%@1%n (%2)", 1);
	add_format("user_info_busy", "%Gzajt%@1%n", 1);
	add_format("user_info_busy_descr", "%Gzajt%@1%n (%2)", 1);
	add_format("user_info_not_avail", "%rniedostpn%@1%n", 1);
	add_format("user_info_not_avail_descr", "%rniedostpn%@1%n (%2)", 1);
	add_format("user_info_invisible", "%cniewidoczn%@1%n", 1);

	add_format("config_changed", "Zapisa now konfiguracj? (tak/nie) ", 1);
	add_format("config_unknown", "%! Zmiana tego ustawienia moe nie odnie zamierzonego efektu\n", 1);

	add_format("private_mode_is_on", "%> Tryb ,,tylko dla przyjaci'' jest wczony\n", 1);
	add_format("private_mode_is_off", "%> Tryb ,,tylko dla przyjaci'' jest wyczony\n", 1);
	add_format("private_mode_on", "%> Wczono tryb ,,tylko dla przyjaci''\n", 1);
	add_format("private_mode_off", "%> Wyczono tryb ,,tylko dla przyjaci''\n", 1);
	add_format("private_mode_invalid", "%! Nieprawidowa warto\n", 1);
	
	add_format("show_status", "%) Aktualny stan: %1%2\n", 1);
	add_format("show_status_avail", "%Ydostpny%n", 1);
	add_format("show_status_avail_descr", "%Ydostpny%n (%1)", 1);
	add_format("show_status_busy", "%Gzajty%n", 1);
	add_format("show_status_busy_descr", "%Gzajty%n (%1)", 1);
	add_format("show_status_invisible", "%bniewidoczny%n", 1);
	add_format("show_status_invisible_descr", "%bniewidoczny%n (%1)", 1);
	add_format("show_status_not_avail", "%rniedostpny%n", 1);
	add_format("show_status_private_on", ", tylko dla znajomych", 1);
	add_format("show_status_private_off", "", 1);

	add_format("aliases_invalid", "%! Nieprawidowy parametr\n", 1);
	add_format("aliases_list_empty", "%! Brak aliasw\n", 1);
	add_format("aliases_list", "%> %W%1 %G-%Y %2%n\n", 1);
	add_format("aliases_add", "%> Dodano alias %W%1 %n-> %2\n", 1);
	add_format("aliases_del", "%) Usunito alias %W%1%n\n", 1);
	add_format("aliases_exist", "%! Alias %W%1%n ju istnieje\n", 1);
	add_format("aliases_noexist", "%! Alias %W%1%n nie istnieje\n", 1);

	add_format("dcc_create_error", "%! Nie mona wczy DCC: %1\n", 1);
	add_format("dcc_error_unknown", "%! Bd krytyczny obsugi DCC: %1\n", 1);
	add_format("dcc_error_handshake", "%! Nie mona nawiza pocznienia z %1\n", 1);
	add_format("dcc_timeout", "%! Timeout DCC\n", 1);
	add_format("dcc_unknown_command", "%! Nieznana opcja: %W%1%n\n", 1);
	add_format("dcc_not_supported", "%! Opcja %W%1%n nie jest jeszcze obsugiwana\n", 1);
	add_format("dcc_open_error", "%! Nie mona otworzy %W%1%n: %2\n", 1);
	add_format("dcc_open_directory", "%! Nie mona otworzy %W%1%n: Jest katalogiem\n", 1);
	add_format("dcc_show_pending_header", "%> Poczenia oczekujce:\n", 1);
	add_format("dcc_show_pending_send", "%) #%1, %2, wysyanie %W%3%n\n", 1);
	add_format("dcc_show_pending_get", "%) #%1, %2, odbir %W%3%n\n", 1);
	add_format("dcc_show_active_header", "%> Poczenia aktywne:\n", 1);
	add_format("dcc_show_active_send", "%) #%1, %2, wysyanie %W%3%n\n", 1);
	add_format("dcc_show_active_get", "%) #%1, %2, odbir %W%3%n\n", 1);
	add_format("dcc_show_empty", "%> Brak bezporednich pocze\n", 1);
	add_format("dcc_show_debug", "%> id=%1, type=%2, filename=%3, uin=%4, dcc=%5\n", 1);
	
	add_format("dcc_done_get", "%> Zakoczono pobieranie pliku %W%2%n od %1\n", 1);
	add_format("dcc_done_send", "%> Zakoczono wysyanie pliku %W%2%n do %1\n", 1);
	
	add_format("dcc_get_offer", "%) %1 przesya plik %W%2%n o rozmiarze %W%3%n\n%) Wpisz %Wdcc get #%4%n by go odebra, lub %Wdcc close #%4%n by anulowa\n", 1);
	add_format("dcc_get_not_found", "%! Nie znaleziono poczenia %W%1%n\n", 1);
	add_format("dcc_get_getting", "%) Rozpoczto pobieranie pliku %W%2%n od %1\n", 1);
	add_format("dcc_get_cant_create", "%! Nie mona utworzy pliku %W%1%n\n", 1);
	

	add_format("query_started", "%) Rozpoczto rozmow z %W%1%n. Aby zakoczy, wcinij Ctrl-D\n", 1);
	add_format("query_finished", "\n%) Zakoczono rozmow z %W%1%n\n", 1);

        add_format("events_list_empty", "%! Brak zdarze\n", 1);
        add_format("events_list", "%> on %G%1 %W%2 %B%3%n\n", 1);
        add_format("events_incorrect", "%! Nieprawidowo zdefiniowane zdarzenie.\n", 1);
        add_format("events_add", "%> 'on %G%1 %W%2 %Y%3%n' - zdarzenie dodane.\n", 1);
        add_format("events_exist", "%! Zdarzenie %1 istnieje dla %2.\n", 1);
        add_format("events_del", "%> 'on %G%1 %W%2 %Y%3%n' - zdarzenie usunite.\n", 1);
        add_format("events_del_flags", "%> Flagi %G%1%n usunite.\n", 1);
        add_format("events_add_flags", "%> Flagi %G%1%n dodane.\n", 1);
        add_format("events_noexist", "%! Niezidentyfikowane zdarzenie.\n", 1);
        add_format("events_del_noexist", "%! Zdarzenie %W%1%n nie istnieje dla uytkownika %G%2%n\n", 1);
        add_format("events_seq_not_found", "%! Sekwencja %W%1%n nie znaleziona.\n", 1);
        add_format("events_act_no_params", "%! %W%1%n - brak parametrw.\n", 1);        
	add_format("events_act_toomany_params", "%! %W%1%n - za duo parametrw.\n", 1);
	add_format("events_seq_incorrect", "%W%1%n - nieprawidowa sekwencja\n", 1);
        add_format("config_line_incorrect", "%! Nieprawidowa linia '%W%1%n', pomijam\n", 1);
        add_format("temporary_run_event", "%) Startujemy z akcj '%B%1%n'\n", 1);
	add_format("autosaved", "%> Automatycznie zapisano ustawienia\n", 1);
	add_format("userlist_put_ok", "%) List kontaktw zachowano na serwerze\n", 1);
	add_format("userlist_put_error", "%! Bd podczas wysyania listy kontaktw\n", 1);
	add_format("userlist_get_ok", "%) List kontaktw wczytano z serwera\n", 1);
	add_format("userlist_get_error", "%! Bd podczas pobierania listy kontaktw\n", 1);
	add_format("change_not_enough_params", "%! Polecenie wymaga podania %wwszystkich%n parametrw\n", 1);

	add_format("window_change_size", "%) Uaktualniono informacj o rozmiarach okna.\n", 1);

	add_format("quick_list", "%)%1\n", 1);
	add_format("quick_list_avail", " %W%1%n", 1);
	add_format("quick_list_busy", " %w%1%n", 1);
	add_format("quick_list_invisible", " %K%1%n", 1);
	add_format("ekg_version", "%) EKG - Eksperymentalny Klient Gadu-Gadu (%W%1%n)\n", 1);
	add_format("registered_today", "%! Ju zarejestrowano jeden numer. Nie naduywaj.\n", 1);
};

