/***************************************************************************
                          chat.cpp  -  description
                             -------------------
    begin                : Sat Sep 8 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include "chat.h"

#include <qwidget.h>
#include <qdialog.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qstring.h>
#include <qfont.h>
#include <qtoolbutton.h>
#include <iostream>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <qlayout.h>

extern gg_session sess;
extern struct config config;
extern chats chats[MAX_CHATS];
extern char * prepare_path(char *);
//extern userlist userlist[MAX_USERS];
extern QArray<userlist> userlist;
extern KApplication *a;
extern Kadu * kadu;
extern void iso_to_cp(unsigned char *);
extern void cp_to_iso(unsigned char *);
extern void playSound(char *);
// extern KApplication * a;


Chat::Chat (const QString & nname, QDialog* parent , const char *name) : QDialog (parent, name) {
	nick = nname;
	this->setWFlags(Qt::WDestructiveClose);
	iconsel_ptr = NULL;
	autosend_enabled = false;

	/* register us in the chats registry... */
	int i = 0;
	while (chats[i].uin != 0)
		i++;

	chats[i].uin = newUserToUin(&nname);
	chats[i].ptr = this;
	index = i;
  /* we don't chat with more than MAX_CHATS people at once we hope */

	this->resize(400,400);
	this->setCaption(i18n("Chat with %1").arg(nname));

	body = new KTextBrowser(this);
//	body -> setVScrollBarMode(QScrollView::AlwaysOn);
	
	edit = new CustomInput(this);
	edit->setGeometry(5,215, 390, 150);
	edit->setWordWrap(QMultiLineEdit::WidgetWidth);

	KIconLoader *loader = KGlobal::iconLoader();

	sendbtn = new QPushButton(this);
	sendbtn->setText(i18n("&Send"));
	sendbtn->setGeometry(320, 375, 75, 20);
	sendbtn->setIconSet(QIconSet( loader->loadIcon("forward", KIcon::Small) ));
	connect(sendbtn, SIGNAL( clicked() ), this, SLOT( sendMessage() ));
 	QAccel *acc = new QAccel( this );
	acc->connectItem( acc->insertItem(Key_Return+CTRL), this, SLOT(sendMessage()) );

	QPushButton * closebtn = new QPushButton(this);
	closebtn->setText(i18n("&Close"));
	closebtn->setGeometry(245, 375, 70, 20);
	closebtn->setIconSet(QIconSet( loader->loadIcon("stop", KIcon::Small) ));
	connect(closebtn, SIGNAL( clicked() ), this, SLOT( cleanUp() ));

	QLabel * edt = new QLabel(this);
	edt->setText(i18n("Edit window:"));
	QToolTip::add(edt, i18n("This is where you type in the text to be sent"));

	buttontray = new QHBox(this);

	autosend = new QPushButton(buttontray);
	autosend->setPixmap(loader->loadIcon("key_enter", KIcon::Small));
	autosend->setToggleButton(true);
	QToolTip::add(autosend, i18n("Enter key sends message"));
	if (config.autosend) {
		autosend->setOn(true);
		autosend_enabled = true;
	}

	iconsel = new QPushButton(buttontray);
	iconsel->setPixmap(loader->loadIcon("icons", KIcon::Small));
	iconsel->setToggleButton(true);

	if (config.emoticons)
		QToolTip::add(iconsel, i18n("Insert emoticon"));
	else {
		QToolTip::add(iconsel, i18n("Insert emoticon - enable in configuration"));
		iconsel->setEnabled(false);
		}

	QPushButton * history = new QPushButton(buttontray);
	history->setPixmap( QPixmap((const char**)history_xpm) );
	QToolTip::add(history, i18n("Show history"));

	QPushButton * whois = new QPushButton(buttontray);
	QPixmap p_whois;
	p_whois = loader->loadIcon("viewmag", KIcon::Small);
	whois->setPixmap(p_whois);
	QToolTip::add(whois, i18n("Lookup user info"));

	connect(autosend, SIGNAL( clicked() ), this, SLOT ( regAutosend() ));
	connect(history, SIGNAL( clicked() ), this, SLOT ( HistoryBox() ));
	connect(iconsel, SIGNAL( clicked() ), this, SLOT ( insertEmoticon() ));
	connect(whois, SIGNAL( clicked() ), this, SLOT ( userWhois() ));

	QGridLayout * grid = new QGridLayout (this, 5, 4, 3, 3);
	grid->addMultiCellWidget(body, 0, 0, 0, 3);
	grid->addWidget(buttontray, 2,3,Qt::AlignRight);
	grid->addMultiCellWidget(edt, 2, 2, 0, 2, Qt::AlignLeft);
	grid->addMultiCellWidget(edit, 3, 3, 0, 3);
	grid->addWidget(closebtn, 4, 2);
	grid->addWidget(sendbtn, 4, 3);
	grid->addRowSpacing(1, 5);
	grid->setRowStretch(0,2);

	QMimeSourceFactory * bodyformat;
	bodyformat = new QMimeSourceFactory;
	if (config.emoticons)
		bodyformat->addFilePath(config.emoticonspath);

	body->setMimeSourceFactory(bodyformat);
  body->setTextFormat(Qt::RichText);

	totaloccurences = 0;

	QObject::connect(edit, SIGNAL( textChanged() ), this, SLOT( timerReset() ) );

	this->show();

}

Chat::~Chat() {
printf("KK Destroy chat: index %d\n", index);
chats[index].uin = 0;
}

/* register/unregister sending with Return key */
void Chat::regAutosend(void) {
	if (!autosend_enabled) {
		autosend_enabled = true;
	} else {
		autosend_enabled = false;
	}
}

CustomInput::CustomInput (Chat* parent, const char *name) : QMultiLineEdit (parent, name) {
  tata = parent;
  }

void CustomInput::keyPressEvent(QKeyEvent * e) {
if (tata->autosend_enabled && ((e->key() == Key_Return) || (e->key() == Key_Enter)))
	tata->sendMessage();
else
  QMultiLineEdit::keyPressEvent(e);

}

/* convert special characters into emoticons, HTML into plain text and so forth */
QString Chat::convertCharacters(QString edit) {

if (config.emoticons) {
edit.replace( QRegExp(__c2q("(<pacze>|<placze>)")), "__escaped_lt__IMG SRC=cry.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<zdziwiony>")), "__escaped_lt__IMG SRC=surprised.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("(<ra>|<roza>)")), "__escaped_lt__IMG SRC=rose.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<kwiatek>")), "__escaped_lt__IMG SRC=flower.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<piwo>")), "__escaped_lt__IMG SRC=beer.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<OK>")), "__escaped_lt__IMG SRC=thumbsup.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<do bani>")), "__escaped_lt__IMG SRC=thumbsdown.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<serce>")), "__escaped_lt__IMG SRC=heart.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<serduszka>")), "__escaped_lt__IMG SRC=hearts.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<kawa>")), "__escaped_lt__IMG SRC=coffee.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<komrka>")), "__escaped_lt__IMG SRC=cell.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<prezent>")), "__escaped_lt__IMG SRC=gift.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<telefon>")), "__escaped_lt__IMG SRC=phone.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<cmok>")), "__escaped_lt__IMG SRC=kiss.gif /__escaped_gt__");
edit.replace( QRegExp(__c2q("<zawstydzony>")), "__escaped_lt__IMG SRC=blush.gif /__escaped_gt__");
edit.replace( QRegExp(":\\)+"), "__escaped_lt__IMG SRC=smile.gif /__escaped_gt__");
edit.replace( QRegExp(":-\\)+"), "__escaped_lt__IMG SRC=smile.gif /__escaped_gt__");
edit.replace( QRegExp(";\\)+"), "__escaped_lt__IMG SRC=wink.gif /__escaped_gt__");
edit.replace( QRegExp(";-\\)+"), "__escaped_lt__IMG SRC=wink.gif /__escaped_gt__");
edit.replace( QRegExp(":\\(+"), "__escaped_lt__IMG SRC=sad.gif /__escaped_gt__");
edit.replace( QRegExp(";\\(+"), "__escaped_lt__IMG SRC=sad.gif /__escaped_gt__");
edit.replace( QRegExp(":-\\(+"), "__escaped_lt__IMG SRC=sad.gif /__escaped_gt__");
edit.replace( QRegExp(":P+"), "__escaped_lt__IMG SRC=grin.gif /__escaped_gt__");
edit.replace( QRegExp(":-P+"), "__escaped_lt__IMG SRC=grin.gif /__escaped_gt__");
edit.replace( QRegExp(";P+"), "__escaped_lt__IMG SRC=grin.gif /__escaped_gt__");
edit.replace( QRegExp(";-P+"), "__escaped_lt__IMG SRC=grin.gif /__escaped_gt__");
edit.replace( QRegExp(":,\\(+"), "__escaped_lt__IMG SRC=cry.gif /__escaped_gt__");
edit.replace( QRegExp(":x+"), "__escaped_lt__IMG SRC=kiss.gif /__escaped_gt__");
		}

edit.replace( QRegExp("<"), "&lt;" );
edit.replace( QRegExp(">"), "&gt;" );
edit.replace( QRegExp("__escaped_lt__"), "<");
edit.replace( QRegExp("__escaped_gt__"), ">");
edit.replace( QRegExp("  "), " &nbsp;" );
edit.replace( QRegExp("\n"), "<BR>" );


  int s = 0;
  int p;
  int l;
  int q;
  for (;;) {
    // find next url
    if (s >= (int)edit.length()) { break; }
    p = edit.find(QRegExp("(http://|www\\.|ftp://ftp\\.)[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{1,4}"), s);

    if (p < 0) { break; }

    // clean up;
    l = (edit.find (" ", p) < 0) ? edit.length() - p : edit.find(" ", p) - p;
    QChar c = edit [l+p-1];
    while ( !( ((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z')) || ((c >= '0') && (c <= '9')) ) )
      c = edit [p-1+(--l)];

    // urlize
    q = edit.find("http://", p);
//    if (q < 0)
//      edit.insert(p, "http://");

    edit = edit.left(p) + "<a href=\"" + ((q < 0) ? "http://" : "") + edit.mid(p,l) + "\">" +
    edit.mid(p,l) + "</a>" + edit.mid(p+l);
  if (q < 0)
    s = p + 2*l + 22;
  else
    s = p + 2*l + 15;
  }

return edit;
}

/* unregister us */
void Chat::closeEvent(QCloseEvent * e)
{
chats[index].uin = 0;
QWidget::closeEvent(e);
}

/* look up party's info */
void Chat::userWhois(void) {
new SearchDialog(0,"User info",UserToUin(nick));
}

/* clean us up */
void Chat::cleanUp(void) {
printf("KK Destroy chat: index %d\n", index);
chats[index].uin = 0;
this->close(true);
}

/* reset autoaway timer, something was pressed */
void Chat::timerReset(void) {
	kadu->autoaway->stop();
	kadu->autoaway->start(300000);
}	

/* not functional yet, custom message formatting */
void Chat::getFormatting(QString &str,int formats_count,struct gg_msg_format * formats) {
int i;
for (i = 0; i < formats_count; i++) {
	switch (formats[i].font) {
		case GG_FONT_BOLD:
			str.insert(formats[i].position,"<B>");
			str.insert(formats[i].position + formats[i].length,"</B>");
			break;
		default:
			break;
		} // end switch
	}  // end for
} // end getFormatting

/* just a prototype */
QString Chat::putFormatting(QString str) {
}

/* invoked from outside when new message arrives, this is the window to the world */
int Chat::checkPresence(uin_t uin, unsigned char * msg, time_t time,int formats_count,struct gg_msg_format * formats) {
	cp_to_iso(msg);
	kadu->autoaway->stop();
	kadu->autoaway->start(300000);

QString toadd;
QString editext = convertCharacters(__c2q((char *)msg));
printf("Numformats %d\n", formats_count);
getFormatting(editext,formats_count,formats);
toadd.append("<TABLE width=\"100%\"><TR><TD bgcolor=\"#F0F0F0\"><B>");
toadd.append(__c2q(UinToUser(uin)));
toadd.append(" ");
toadd.append(__c2q(timestamp(time)));
toadd.append("</B><BR>");
toadd.append(editext);
toadd.append("</TD></TR></TABLE>");

if (config.chatprune)
	pruneWindow();

if (!config.scrolldown)
	body->setText(toadd + body->text());
else {
	QScrollBar *scrollbar = body->verticalScrollBar();
	bool scrollbarVisible = scrollbar->isVisible();
	body->setText(body->text() + toadd);
	a->processEvents();
	int Height = 0;
	while (Height != body->contentsHeight()) {
		Height = body->contentsHeight();
		a->processEvents();
		}
	body->ensureVisible(0, Height);
	if (!scrollbarVisible && scrollbar->isVisible())
	    {
	    body->repaintContents();
	    a->processEvents();
	    }
}

	
	/* let's show we have something new */
	if (config.playsoundchatinvisible && config.playsoundchat) {
		if (!this->isActiveWindow())
	     alertNewMessage();
		return 0;
		}
	else if (config.playsoundchat)
		alertNewMessage();

	return 0;
}

void Chat::alertNewMessage(void) {
   playSound(config.soundchat);
	}

/* sends the message typed */
void Chat::sendMessage(void) {
kadu->autoaway->stop();
kadu->autoaway->start(300000);

if (QString::compare(edit->text().local8Bit(),"") == 0) return;

QString toadd;
QString editext = convertCharacters(edit->text());

toadd.append("<TABLE WIDTH=\"100%\"><TR><TD bgcolor=\"#E0E0E0\"><B>Me ");
toadd.append(__c2q(timestamp()));
toadd.append("</B><BR>");
toadd.append(editext);
toadd.append("</TD></TR></TABLE>");

if (config.chatprune)
	pruneWindow();

if (!config.scrolldown)
	body->setText(toadd + body->text());
else {
	QScrollBar *scrollbar = body->verticalScrollBar();
	bool scrollbarVisible = scrollbar->isVisible();
	body->setText(body->text() + toadd);
	a->processEvents();
	int Height = 0;
	while (Height != body->contentsHeight()) {
		Height = body->contentsHeight();
		a->processEvents();
		}
	body->ensureVisible(0, Height);
	if (!scrollbarVisible && scrollbar->isVisible())
	    {
	    body->repaintContents();
	    a->processEvents();
	    }

//edit->clear();
}

int uin;
QString text;
text = edit->text();
QCString tmp(text.local8Bit());
unsigned char * utmp = (unsigned char *) tmp.data();	

edit->setReadOnly(true);
uin = UserToUin(nick);
if (config.logmessages)
	appendHistory(uin, utmp, true);
iso_to_cp(utmp);
gg_send_message(&sess, GG_CLASS_CHAT, uin, utmp);
edit->setReadOnly(false);	
edit->clear();

}


/* prunes messages */
void Chat::pruneWindow(void) {

	if (config.scrolldown) {
	  int index = -1;
		int occurences = 0;
		while (occurences != config.chatprunelen && totaloccurences > config.chatprunelen - 1) {
			index = body->text().findRev(QString("<TABLE"), index - 8);
			occurences++;
		}
		totaloccurences++;
		
		body->setText( body->text().right( body->text().length() - index ) );
		
	} else {
		int index = 0;
		int occurences = 0;
		while (occurences != config.chatprunelen && totaloccurences > config.chatprunelen ) {
			if (occurences == 0)
				index = body->text().find(QString("<TABLE"), 0);
			else
				index = body->text().find(QString("<TABLE"), index + 8);
		
			occurences++;
		}
		totaloccurences++;
	
	if (totaloccurences > config.chatprunelen && index != -1 && index != 0)
		body->setText( body->text().left( index ) );

	}

}

/* opens messages history */
void Chat::HistoryBox (void) {
new HistorybBox(UserToUin(nick));
}

/* this nifty icon selector */
void Chat::insertEmoticon(void) {
if (iconsel_ptr == NULL) {
	iconsel->setOn(true);
	iconsel_ptr = new IconSelector(this,"Icon selector",this);
} else {
	iconsel->setOn(false);
	iconsel_ptr->close(true);
	iconsel_ptr = NULL;
	}

}

/* adds an emoticon code to the edit window */
void Chat::addEmoticon(QString string) {
edit->setText(edit->text() + string);
edit->end();
iconsel_ptr = NULL;
iconsel->setOn(false);
}

/* the icon selector itself */
IconSelector::IconSelector(QWidget *parent, const char *name, Chat * caller) : QWidget (parent, name) {
callingwidget = caller;
this->setWFlags(Qt::WDestructiveClose||Qt::WStyle_NoBorder||Qt::WStyle_NoBorderEx||Qt::WX11BypassWM);

QString path;
path.append(config.emoticonspath);
QGridLayout * grid = new QGridLayout(this,4,4,0,0);

QToolButton * icon_1_1 = new QToolButton(this);
icon_1_1->setPixmap(QPixmap(path + "smile.gif"));
icon_1_1->setAutoRaise(true);
grid->addWidget(icon_1_1,0,0);
QObject::connect(icon_1_1, SIGNAL( clicked() ), this, SLOT( slot_1_1() ));

QToolButton * icon_1_2 = new QToolButton(this);
icon_1_2->setPixmap(QPixmap(path + "sad.gif"));
icon_1_2->setAutoRaise(true);
grid->addWidget(icon_1_2,0,1);
QObject::connect(icon_1_2, SIGNAL( clicked() ), this, SLOT( slot_1_2() ));

QToolButton * icon_1_3 = new QToolButton(this);
icon_1_3->setPixmap(QPixmap(path + "surprised.gif"));
icon_1_3->setAutoRaise(true);
grid->addWidget(icon_1_3,0,2);
QObject::connect(icon_1_3, SIGNAL( clicked() ), this, SLOT( slot_1_3() ));

QToolButton * icon_1_4 = new QToolButton(this);
icon_1_4->setPixmap(QPixmap(path + "wink.gif"));
icon_1_4->setAutoRaise(true);
grid->addWidget(icon_1_4,0,3);
QObject::connect(icon_1_4, SIGNAL( clicked() ), this, SLOT( slot_1_4() ));

QToolButton * icon_2_1 = new QToolButton(this);
icon_2_1->setPixmap(QPixmap(path + "beer.gif"));
icon_2_1->setAutoRaise(true);
grid->addWidget(icon_2_1,1,0);
QObject::connect(icon_2_1, SIGNAL( clicked() ), this, SLOT( slot_2_1() ));

QToolButton * icon_2_2 = new QToolButton(this);
icon_2_2->setPixmap(QPixmap(path + "cry.gif"));
icon_2_2->setAutoRaise(true);
grid->addWidget(icon_2_2,1,1);
QObject::connect(icon_2_2, SIGNAL( clicked() ), this, SLOT( slot_2_2() ));

QToolButton * icon_2_3 = new QToolButton(this);
icon_2_3->setPixmap(QPixmap(path + "grin.gif"));
icon_2_3->setAutoRaise(true);
grid->addWidget(icon_2_3,1,2);
QObject::connect(icon_2_3, SIGNAL( clicked() ), this, SLOT( slot_2_3() ));

QToolButton * icon_2_4 = new QToolButton(this);
icon_2_4->setPixmap(QPixmap(path + "coffee.gif"));
icon_2_4->setAutoRaise(true);
grid->addWidget(icon_2_4,1,3);
QObject::connect(icon_2_4, SIGNAL( clicked() ), this, SLOT( slot_2_4() ));

QToolButton * icon_3_1 = new QToolButton(this);
icon_3_1->setPixmap(QPixmap(path + "flower.gif"));
icon_3_1->setAutoRaise(true);
grid->addWidget(icon_3_1,2,0);
QObject::connect(icon_3_1, SIGNAL( clicked() ), this, SLOT( slot_3_1() ));

QToolButton * icon_3_2 = new QToolButton(this);
icon_3_2->setPixmap(QPixmap(path + "rose.gif"));
icon_3_2->setAutoRaise(true);
grid->addWidget(icon_3_2,2,1);
QObject::connect(icon_3_2, SIGNAL( clicked() ), this, SLOT( slot_3_2() ));

QToolButton * icon_3_3 = new QToolButton(this);
icon_3_3->setPixmap(QPixmap(path + "heart.gif"));
icon_3_3->setAutoRaise(true);
grid->addWidget(icon_3_3,2,2);
QObject::connect(icon_3_3, SIGNAL( clicked() ), this, SLOT( slot_3_3() ));

QToolButton * icon_3_4 = new QToolButton(this);
icon_3_4->setPixmap(QPixmap(path + "thumbsup.gif"));
icon_3_4->setAutoRaise(true);
grid->addWidget(icon_3_4,2,3);
QObject::connect(icon_3_4, SIGNAL( clicked() ), this, SLOT( slot_3_4() ));

QToolButton * icon_4_1 = new QToolButton(this);
icon_4_1->setPixmap(QPixmap(path + "thumbsdown.gif"));
icon_4_1->setAutoRaise(true);
grid->addWidget(icon_4_1,3,0);
QObject::connect(icon_4_1, SIGNAL( clicked() ), this, SLOT( slot_4_1() ));

QToolButton * icon_4_2 = new QToolButton(this);
icon_4_2->setPixmap(QPixmap(path + "gift.gif"));
icon_4_2->setAutoRaise(true);
grid->addWidget(icon_4_2,3,1);
QObject::connect(icon_4_2, SIGNAL( clicked() ), this, SLOT( slot_4_2() ));

QToolButton * icon_4_3 = new QToolButton(this);
icon_4_3->setPixmap(QPixmap(path + "cell.gif"));
icon_4_3->setAutoRaise(true);
grid->addWidget(icon_4_3,3,2);
QObject::connect(icon_4_3, SIGNAL( clicked() ), this, SLOT( slot_4_3() ));

QToolButton * icon_4_4 = new QToolButton(this);
icon_4_4->setPixmap(QPixmap(path + "phone.gif"));
icon_4_4->setAutoRaise(true);
grid->addWidget(icon_4_4,3,3);
QObject::connect(icon_4_4, SIGNAL( clicked() ), this, SLOT( slot_4_4() ));

this->move(callingwidget->buttontray->x() - this->sizeHint().width() + icon_1_4->sizeHint().width(),
	callingwidget->buttontray->y() + callingwidget->buttontray->height());

this->show();
}

/* a set of slots. tell me it can be done better. */
void IconSelector::slot_1_1() { callingwidget->addEmoticon(":)"); this->close(true); };
void IconSelector::slot_1_2() { callingwidget->addEmoticon(":("); this->close(true);  };
void IconSelector::slot_1_3() { callingwidget->addEmoticon("<zdziwiony>"); this->close(true);  };
void IconSelector::slot_1_4() { callingwidget->addEmoticon(";)"); this->close(true);  };

void IconSelector::slot_2_1() { callingwidget->addEmoticon("<piwo>"); this->close(true);  };
void IconSelector::slot_2_2() { callingwidget->addEmoticon(__c2q("<pacze>")); this->close(true);  };
void IconSelector::slot_2_3() { callingwidget->addEmoticon(";P"); this->close(true);  };
void IconSelector::slot_2_4() { callingwidget->addEmoticon("<kawa>"); this->close(true);  };

void IconSelector::slot_3_1() { callingwidget->addEmoticon("<kwiatek>"); this->close(true);  };
void IconSelector::slot_3_2() { callingwidget->addEmoticon("<roza>"); this->close(true);  };
void IconSelector::slot_3_3() { callingwidget->addEmoticon("<serce>"); this->close(true);  };
void IconSelector::slot_3_4() { callingwidget->addEmoticon("<OK>"); this->close(true);  };

void IconSelector::slot_4_1() { callingwidget->addEmoticon("<do bani>"); this->close(true); };
void IconSelector::slot_4_2() { callingwidget->addEmoticon("<prezent>"); this->close(true);  };
void IconSelector::slot_4_3() { callingwidget->addEmoticon("<komrka>"); this->close(true);  };
void IconSelector::slot_4_4() { callingwidget->addEmoticon("<telefon>"); this->close(true);  };

