/***************************************************************************
                          config.cpp  -  description
                             -------------------
    begin                : Thu Feb 14 2002
    copyright            : (C) 2002 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include <qfiledialog.h>
#include <math.h>
#include <qvgroupbox.h>

extern struct config config;
extern QArray<userlist> userlist;
extern Kadu * kadu;

ConfigDialog::ConfigDialog(QWidget *parent, const char *name) : QTabDialog (parent, name) {

this->setWFlags(Qt::WDestructiveClose);
setupTab1();
setupTab2();
setupTab3();
setupTab4();
connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( updateConfig() ) );
setCancelButton(i18n("Cancel"));
connect( this, SIGNAL( cancelButtonPressed() ), this, SLOT( close() ) );
this->setCaption(i18n("Kadu configuration"));
this->resize(300,380);
this->show();

}

void ConfigDialog::setupTab1(void) {

QVBox * box = new QVBox(this);
box->setMargin(5);

QHGroupBox * userinfo = new QHGroupBox(box);
userinfo->setTitle(i18n("User data"));

QLabel * l_uin = new QLabel(userinfo);
l_uin->setText(i18n("Uin"));

char uin[12];
snprintf(uin, sizeof(uin), "%d", config.uin);
e_uin = new QLineEdit(userinfo);
e_uin->setText(uin);

QLabel * l_password = new QLabel(userinfo);
l_password->setText(i18n("Password"));

e_password = new QLineEdit(userinfo);
e_password->setEchoMode(QLineEdit::Password);
e_password->setText(config.password);

/* SMS begin */
QVGroupBox * smsvgrp = new QVGroupBox(box);
smsvgrp->setTitle(i18n("SMS options"));

QHBox * smshbox1 = new QHBox(smsvgrp);
smshbox1->setSpacing(5);
QLabel * l_smsapp = new QLabel(smshbox1);
l_smsapp->setText(i18n("SMS application"));
e_smsapp = new QLineEdit(smshbox1);
e_smsapp->setText(config.smsapp);

b_smscustomconf = new QCheckBox(smsvgrp);
b_smscustomconf->setText(i18n("Enable custom string formatting"));
QToolTip::add(b_smscustomconf,i18n("Check this box if your sms application doesn't understand sms number \"message\"\nThe string formatting is %s for app, %d for number and %s for message\nand the order is %s %d %s"));

QHBox * smshbox2 = new QHBox(smsvgrp);
smshbox2->setSpacing(5);
QLabel * l_smsconf = new QLabel(smshbox2);
l_smsconf->setText(i18n("SMS custom string"));
e_smsconf = new QLineEdit(smshbox2);
e_smsconf->setText(config.smsconf);

if (config.smscustomconf)
	b_smscustomconf->setEnabled(true);
else
	smshbox2->setEnabled(false);

QObject::connect(b_smscustomconf, SIGNAL( toggled(bool) ), smshbox2, SLOT( setEnabled(bool) ) );


/* SMS end */

b_autoaway = new QCheckBox(box);
b_autoaway->setText(i18n("Enable autoaway"));

QHGroupBox * awygrp = new QHGroupBox(box);
QLabel * l_autoaway = new QLabel(awygrp);
l_autoaway->setText(i18n("Set status to away after "));

char czas[8];
snprintf(czas, sizeof(czas), "%d", config.autoawaytime);

e_autoawaytime = new QLineEdit(awygrp);
e_autoawaytime->setText(czas);

QLabel * l_autoaway2 = new QLabel(awygrp);
l_autoaway2->setText(i18n(" seconds"));

if (config.autoaway)
	b_autoaway->setChecked(true);
else
	awygrp->setEnabled(false);

QObject::connect(b_autoaway, SIGNAL( toggled(bool) ), awygrp, SLOT( setEnabled(bool) ));

b_logging = new QCheckBox(box);
b_logging->setText(i18n("Log messages"));
if (config.logmessages)
	b_logging->setChecked(true);

b_geometry = new QCheckBox(box);
b_geometry->setText(i18n("Restore window geometry"));
if (config.savegeometry)
	b_geometry->setChecked(true);

b_dock = new QCheckBox(box);
b_dock->setText(i18n("Enable dock icon"));
if (config.dock)
	b_dock->setChecked(true);

addTab(box, i18n("General"));
}

void ConfigDialog::setupTab2(void) {
KIconLoader *loader = KGlobal::iconLoader();
QVBox * box2 = new QVBox(this);
box2->setMargin(5);	

b_playsound = new QCheckBox(box2);
b_playsound->setText(i18n("Play sounds"));

b_playartsdsp = new QCheckBox(box2);
b_playartsdsp->setText(i18n("Play sounds using aRts! server"));
if (config.playartsdsp)
	b_playartsdsp->setChecked(true);

if (config.playsound)
	b_playsound->setChecked(true);
else
	b_playartsdsp->setEnabled(false);

QObject::connect(b_playsound, SIGNAL( toggled(bool) ), b_playartsdsp, SLOT( setEnabled(bool) ) );


QHGroupBox * sndgroup = new QHGroupBox(box2);
sndgroup->setTitle(i18n("Sound player"));
e_soundprog = new QLineEdit(sndgroup);
e_soundprog->setText(config.soundprog);

QPushButton * f_soundprog = new QPushButton(sndgroup);
f_soundprog->setPixmap(loader->loadIcon("fileopen", KIcon::Small));
connect(f_soundprog, SIGNAL( clicked() ), this, SLOT( choosePlayerFile() ));

b_soundvolctrl = new QCheckBox(box2);
b_soundvolctrl->setText(i18n("Enable volume control (player must support it)"));

QHBox * volbox = new QHBox(box2);
volbox->setSpacing(5);
QLabel * l_vol = new QLabel(volbox);
l_vol->setText(i18n("Volume"));
s_volume = new QSlider(0,400,1,(int)floor(config.soundvol * 100),Qt::Horizontal,volbox);
s_volume->setTickmarks(QSlider::Below);
s_volume->setTickInterval(50);

if (config.soundvolctrl)
	b_soundvolctrl->setChecked(true);
else
	volbox->setEnabled(false);

QObject::connect(b_soundvolctrl, SIGNAL( toggled(bool) ), volbox, SLOT( setEnabled(bool) ) );


QHGroupBox * msggroup = new QHGroupBox(box2);
msggroup->setTitle(i18n("Message sound"));

e_msgfile = new QLineEdit(msggroup);
e_msgfile->setText(config.soundmsg);

QPixmap icon;
icon = loader->loadIcon("fileopen", KIcon::Small);
QPushButton * msgsnd = new QPushButton(msggroup);
msgsnd->setPixmap(icon);
connect(msgsnd, SIGNAL( clicked() ), this, SLOT( chooseMsgFile() ));

b_playchat = new QCheckBox(box2);
b_playchat->setText(i18n("Play sounds from a person whilst chatting"));
b_playchatinvisible = new QCheckBox(box2);
b_playchatinvisible->setText(i18n("Play chat sounds only when window is invisible"));
QObject::connect(b_playchat, SIGNAL( toggled(bool) ), b_playchatinvisible, SLOT( setEnabled(bool) ) );

if (config.playsoundchat)
	b_playchat->setChecked(true);
else
	b_playchatinvisible->setEnabled(false);

if (config.playsoundchatinvisible)
	b_playchatinvisible->setChecked(true);


QHGroupBox * chatgroup = new QHGroupBox(box2);
chatgroup->setTitle(i18n("Chat sound"));

e_chatfile = new QLineEdit(chatgroup);
e_chatfile->setText(config.soundchat);

QPushButton * chatsnd = new QPushButton(chatgroup);
chatsnd->setPixmap(icon);
connect(chatsnd, SIGNAL( clicked() ), this, SLOT( chooseChatFile() ));



addTab(box2, i18n("Sounds"));
	}

void ConfigDialog::setupTab3(void) {
KIconLoader *loader = KGlobal::iconLoader();
QVBox * box3 = new QVBox(this);
box3->setMargin(5);	

b_emoticons = new QCheckBox(box3);
b_emoticons->setText(i18n("Enable emoticons in chat window"));

QHGroupBox * emogroup = new QHGroupBox(box3);
emogroup->setTitle(i18n("Emoticons path"));

e_emoticonspath = new QLineEdit(emogroup);
e_emoticonspath->setText(config.emoticonspath);

QPushButton * emoget = new QPushButton(emogroup);
emoget->setPixmap(loader->loadIcon("fileopen", KIcon::Small));
connect(emoget, SIGNAL( clicked() ), this, SLOT( chooseEmoticonsPath() ));

if (config.emoticons)
	b_emoticons->setChecked(true);
else
	emogroup->setEnabled(true);

QObject::connect(b_emoticons,SIGNAL( toggled(bool) ), emogroup, SLOT( setEnabled(bool) ));
QObject::connect(b_emoticons, SIGNAL( toggled(bool) ), this, SLOT( emoticonsEnabled(bool) ) );

b_chatprune = new QCheckBox(box3);
b_chatprune->setText(i18n("Automatically prune chat messages"));


QHGroupBox * prunebox = new QHGroupBox(box3);
prunebox->setTitle(i18n("Message pruning"));

QLabel * l_chatprunedsc1 = new QLabel(prunebox);
l_chatprunedsc1->setText(i18n("Reduce the number of visible messages to"));

e_chatprunelen = new QLineEdit(prunebox);
e_chatprunelen->setText(QString::number(config.chatprunelen));

if (config.chatprune)
	b_chatprune->setChecked(true);
else
	prunebox->setEnabled(false);

QObject::connect(b_chatprune, SIGNAL( toggled(bool) ), prunebox, SLOT( setEnabled(bool) ));

b_scrolldown = new QCheckBox(box3);
b_scrolldown->setText(i18n("Scroll chat window downward, not upward"));
if (config.scrolldown)
	b_scrolldown->setChecked(true);

b_autosend = new QCheckBox(box3);
b_autosend->setText(i18n("\"Enter\" key in chat sends message by default"));
if (config.autosend)
	b_autosend->setChecked(true);


addTab(box3, i18n("Chat"));
}

void ConfigDialog::setupTab4(void) {
KIconLoader *loader = KGlobal::iconLoader();
QVBox * box4 = new QVBox(this);
box4->setMargin(2);	

b_notifyglobal = new QCheckBox(box4);
b_notifyglobal->setText(i18n("Notify when users become available"));

/* two nice panes */
QHBox * panebox = new QHBox(box4);

QVBox * vbox1 = new QVBox(panebox);
QLabel * _l1 = new QLabel(vbox1);
_l1->setText(i18n("Available"));
e_availusers = new QListBox(vbox1);
int i = 0;
while (i < userlist.size()) {
    if (userlist[i].uin)
	e_availusers->insertItem(__c2q(userlist[i].nickname));
    i++;
    }
    
QVBox * vbox2 = new QVBox(panebox);
QPushButton * _goRight = new QPushButton (vbox2);
_goRight->setPixmap( loader->loadIcon("forward", KIcon::Small) );

QPushButton * _goLeft = new QPushButton (vbox2);
_goLeft->setPixmap( loader->loadIcon("back", KIcon::Small) );

QObject::connect(_goRight, SIGNAL( clicked() ), this, SLOT( _Right() ));
QObject::connect(_goLeft, SIGNAL( clicked() ), this, SLOT( _Left() ));

QVBox * vbox3 = new QVBox(panebox);
QLabel * _l2 = new QLabel(vbox3);
_l2->setText(i18n("Tracked"));
e_notifies = new QListBox(vbox3);

QStringList::Iterator it;
for (it = config.notifies.begin(); it != config.notifies.end(); ++it) {
	e_notifies->insertItem(__c2q(UinToUser(atoi((*it).latin1()))));
	for (int i = 0; i < e_availusers->count(); i++) {
		if (UserToUin(e_availusers->item(i)->text().local8Bit()) == atoi((*it).latin1()))
			e_availusers->removeItem(i);
		}

	}						

/* end two panes */


QVGroupBox * notifybox = new QVGroupBox(box4);
notifybox->setTitle(i18n("Notify options"));
notifybox->setMargin(2);

if (config.notifyglobal)
	b_notifyglobal->setChecked(true);
else
	notifybox->setEnabled(false);


b_notifysound = new QCheckBox(notifybox);
b_notifysound->setText(i18n("Notify by sound"));

QHGroupBox * soundbox = new QHGroupBox(notifybox);
soundbox->setTitle(i18n("Notify sound"));
e_soundnotify = new QLineEdit(soundbox);
e_soundnotify->setText(config.soundnotify);

QPushButton * nsndget = new QPushButton(soundbox);
nsndget->setPixmap(loader->loadIcon("fileopen", KIcon::Small));
connect(nsndget, SIGNAL( clicked() ), this, SLOT( chooseNotifyFile() ));

b_notifydialog = new QCheckBox(notifybox);
b_notifydialog->setText(i18n("Notify by dialog box"));

if (config.notifydialog)
	b_notifydialog->setChecked(true);

if (config.notifysound)
	b_notifysound->setChecked(true);
else
	soundbox->setEnabled(false);

QObject::connect(b_notifysound, SIGNAL(toggled(bool)), soundbox, SLOT(setEnabled(bool)));
QObject::connect(b_notifyglobal, SIGNAL(toggled(bool)), notifybox, SLOT(setEnabled(bool)));

addTab(box4, i18n("Users"));
}

void ConfigDialog::_Left(void) {
if (e_notifies->currentItem() != -1)
    {
    e_availusers->insertItem(e_notifies->text(e_notifies->currentItem()));
    e_notifies->removeItem(e_notifies->currentItem());
    }
}

void ConfigDialog::_Right(void) {
if (e_availusers->currentItem() != -1)
    {
    e_notifies->insertItem(e_availusers->text(e_availusers->currentItem()));
    e_availusers->removeItem(e_availusers->currentItem());
    }
}

void ConfigDialog::chooseMsgFile(void) {
 QString s(QFileDialog::getOpenFileName( QString::null, "Audio Files (*.wav *.au *.raw)", this ));
	e_msgfile->setText(s);
	}

void ConfigDialog::chooseNotifyFile(void) {
 QString s(QFileDialog::getOpenFileName( QString::null, "Audio Files (*.wav *.au *.raw)", this ));
	e_soundnotify->setText(s);
	}


void ConfigDialog::chooseEmoticonsPath(void) {
 QString s(QFileDialog::getExistingDirectory( QString::null, this ));
	e_emoticonspath->setText(s);
	}

void ConfigDialog::chooseChatFile(void) {
 QString s(QFileDialog::getOpenFileName( QString::null, "Audio Files (*.wav *.au *.raw)", this ));
	e_chatfile->setText(s);
	}

void ConfigDialog::choosePlayerFile(void) {
 QString s(QFileDialog::getOpenFileName( QString::null, "All Files (*)", this ));
	e_soundprog->setText(s);
	}

void ConfigDialog::emoticonsEnabled(bool enabled) {
		if (enabled)
		QMessageBox::information(this, "Emoticons", i18n("You have enabled the usage of emoticons.\nPlease make sure you will have set the right path\nto the directory where all emoticons are stored") );
}

void ConfigDialog::updateConfig(void) {
	config.uin = atoi(e_uin->text().latin1());
	free(config.password);
	config.password = strdup(e_password->text().local8Bit());
	config.savegeometry = b_geometry->isChecked();
	config.logmessages = b_logging->isChecked();
	config.playsoundchat = b_playchat->isChecked();
	config.playsoundchatinvisible = b_playchatinvisible->isChecked();
	free(config.soundmsg);
	config.soundmsg = strdup(e_msgfile->text().local8Bit());
	free(config.soundchat);
	config.soundchat = strdup(e_chatfile->text().local8Bit());
	config.soundprog = strdup(e_soundprog->text().latin1());
	config.playsound = b_playsound->isChecked();
	config.playartsdsp = b_playartsdsp->isChecked();
	config.soundvol = (double) s_volume->value();
	config.soundvol /= 100;
	config.soundvolctrl = b_soundvolctrl->isChecked();
	config.autoaway = b_autoaway->isChecked();
	config.autoawaytime = atoi(e_autoawaytime->text().latin1());
	config.dock = b_dock->isChecked();

	config.smsapp = strdup(e_smsapp->text().latin1());
	config.smsconf = strdup(e_smsconf->text().latin1());
	config.smscustomconf = b_smscustomconf->isChecked();

	config.emoticons = b_emoticons->isChecked();
	config.autosend = b_autosend->isChecked();
	config.scrolldown = b_scrolldown->isChecked();
	config.emoticonspath = strdup(e_emoticonspath->text().latin1());
	config.chatprune = b_chatprune->isChecked();
	config.chatprunelen = atoi(e_chatprunelen->text().latin1());

	free(config.soundnotify);
	config.soundnotify = strdup(e_soundnotify->text().latin1());
	config.notifyglobal = b_notifyglobal->isChecked();
	config.notifysound = b_notifysound->isChecked();
	config.notifydialog = b_notifydialog->isChecked();

	config.notifies.clear();
	for (int i = 0; i < e_notifies->count(); i++) {
		config.notifies.append(QString::number(UserToUin(e_notifies->text(i))));
		}

  /* and now, save it */
  kadu->saveConfiguration();
	
	}
