/***************************************************************************
                          dcc.cpp  -  description
                             -------------------
    begin                : Tue Feb 19 2002
    copyright            : (C) 2002 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include "qfiledialog.h"
#include <iostream>
#include <fcntl.h>

extern Kadu * kadu;
extern struct config config;

DccGet::DccGet(struct gg_dcc * dcc_ptr, QDialog *parent, const char *name) : QDialog (parent, name) {
vbox1 = new QVBox(this);
vbox1->setMargin(5);
dccsock = dcc_ptr;
this->setWFlags(Qt::WDestructiveClose);
stimer = new QTimer(this);
QObject::connect(stimer, SIGNAL(timeout()), this, SLOT(watchSocket()));		
stimer->start(100);

}

void DccGet::askAccept(void) {
	printf("Ask accept\n");

QString str;
str.append(i18n("User "));
str.append(UinToUser(dccsock->peer_uin));
str.append(i18n(" wants to send us a file "));
str.append((char *)dccsock->file_info.filename);
str.append(i18n("\nof size "));
char fsize[20];
snprintf(fsize, sizeof(fsize), "%.1fKB", (float) dccsock->file_info.size/1024);
str.append(fsize);
str.append(i18n(". Accept transfer?"));

  switch( QMessageBox::information( 0, "Incoming transfer",str,"No", "Yes", 0, 0, 1) ) {
 case 1: // Yes?
			printf("I accept\n");
			prepareToWrite();
			break;
  case 0:
			printf("I discard\n");
			gg_free_event(dcc_e);
			gg_dcc_free(dccsock);
			this->close(true);
			return;
  }

}

void DccGet::prepareToWrite(void) {

 opnfl: QString f = QFileDialog::getSaveFileName( (char *)dccsock->file_info.filename, QString::null, 0, "save file", "Select file location" );
    if ( f.isEmpty() ) {
				QMessageBox::warning(this, "File not specified", i18n("Please specify a file") );
				goto opnfl;
    }


    std::cout << "Opening" + f << std::endl;


			if ((dccsock->file_fd = open(f.latin1(), O_WRONLY | O_CREAT, 0600)) == -1) {
					QMessageBox::warning(this, "Connect error", i18n("Could not open file") );
						exit: gg_free_event(dcc_e);
						gg_dcc_free(dccsock);
						this->close(true);
						return;
						}

		/* GUI */
			numshots = 1;
			
			QLabel * l_sender = new QLabel(vbox1);
			QString sender;
			sender.append("Sender: ");
			sender.append(UinToUser(dccsock->peer_uin));
			l_sender->setText(sender);

			QLabel * l_filename = new QLabel(vbox1);
			sender.truncate(0);

			sender.append("Filename: ");
			sender.append((char *)dccsock->file_info.filename);
			l_filename->setText(sender);

			QLabel * l_filesize = new QLabel(vbox1);
			sender.truncate(0);
			
			sender.append("File size: ");
			sender.append(QString::number(dccsock->file_info.size));
			sender.append("b");
	
			l_filesize->setText(sender);


			l_offset = new QLabel(vbox1);			
			l_offset->setText("Speed: 0.00KB (not started)  ");

			p_progress = new QProgressBar((int) dccsock->file_info.size / 1024, vbox1);

			vbox1->resize(vbox1->sizeHint());
			this->resize(vbox1->sizeHint().width() + 15, vbox1->sizeHint().height() + 15);
			this->show();
			this->setCaption(i18n("File transfer"));

			gg_free_event(dcc_e);
			watchSocket();
			stimer->start(25);



}

void DccGet::watchSocket(void) {
		FD_ZERO(&dcc_rd);
		FD_ZERO(&dcc_wd);

		if ((dccsock->check & GG_CHECK_READ))
			FD_SET(dccsock->fd, &dcc_rd);
		if ((dccsock->check & GG_CHECK_WRITE))
			FD_SET(dccsock->fd, &dcc_wd);

		dcc_tv.tv_sec = 0;
		dcc_tv.tv_usec = 500;

		dcc_ret = select(dccsock->fd + 1, &dcc_rd, &dcc_wd, NULL, &dcc_tv);

		if (numshots > 0) {
			if (numshots % 39 == 0)
				prev_offset = dccsock->offset;

			if (numshots % 17 == 0 && this->isVisible()) {
			if (prev_offset == dccsock->offset)
				tmptxt.sprintf("Speed: %.2fKB (stalled)",(double) dccsock->offset / (numshots * 10) );	
			else {
				tmptxt.sprintf("Speed: %.2fKB",(double) dccsock->offset / (numshots * 10) );	
        p_progress->setProgress(dccsock->offset / 1024);
				}

				l_offset->setText(tmptxt);
			}
			numshots++;
			}

		if (!dcc_ret) {
			return;
		} else { // begin main block
			fprintf(stderr, "KK DccGet(): data on socket\n");			
				if (!(dcc_e = gg_dcc_watch_fd(dccsock))) {
					printf("KK Connection broken unexpectedly!\n");
					gg_dcc_free(dccsock);
					config.allowdcc = false;
					return;
					}

		switch (dcc_e->type) {
			case GG_EVENT_NONE:
				break;
/*			case GG_EVENT_DCC_CLIENT_ACCEPT:
				printf("KK GG_EVENT_DCC_CLIENT_ACCEPT: %d %d\n", dccsock->uin, dccsock->peer_uin);
				break; */
			case GG_EVENT_DCC_NEED_FILE_ACK:
				stimer->stop();
				printf("KK GG_EVENT_DCC_NEED_FILE_ACK! %d %d\n", dccsock->uin, dccsock->peer_uin);
				askAccept();
				return;
				break;
			case GG_EVENT_DCC_ERROR:
				stimer->stop();
				if (l_offset->isVisible())
					l_offset->setText("Speed: IO ERROR");
				printf("KK GG_EVENT_DCC_ERROR\n");
				break;
			case GG_EVENT_DCC_DONE:
				stimer->stop();
				l_offset->setText("Speed: DONE");
				printf("GG_EVENT_DCC_DONE\n");
			default:
				break;

			}


		gg_free_event(dcc_e);

		} // end main block

}



