/***************************************************************************
                          events.cpp  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"

#include <qwidget.h>
#include <qdialog.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qstring.h>
#include <iostream>

#define _USE_BSD
#include <sys/types.h>
#include <sys/resource.h>
 #include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

extern QArray<userlist> userlist;
extern QArray<pending> pending;
extern MyListBox * mylist;
extern Kadu * kadu;
extern KApplication * a;
extern chats chats[MAX_CHATS];
extern DockWidget * dw;
extern int userlist_count;
extern bool mute;
extern struct acks acks[MAX_ACK];
extern struct gg_session sess;
extern struct config config;
extern void playSound(char *);
extern QArray<groups> grouplist;

void iso_to_cp(unsigned char *);
void cp_to_iso(unsigned char *);


char *get_token(char **ptr, char sep)
{
	char *foo, *res;

	if (!ptr || !sep || !*ptr)
		return NULL;

	res = *ptr;

	if (!(foo = strchr(*ptr, sep)))
		*ptr += strlen(*ptr);
	else {
		*ptr = foo + 1;
		*foo = 0;
	}

	return res;
}

char *read_file(FILE *f) {
	char buf[1024], *nju, *res = NULL;

	while (fgets(buf, sizeof(buf) - 1, f)) {
		int new_size = ((res) ? strlen(res) : 0) + strlen(buf) + 1;

		if (!((void *)nju = realloc(res, new_size))) {
			/* jesli brakuje pamieci, pomijamy reszte linii */
			if (strchr(buf, '\n'))
				break;
			else
				continue;
		}
		if (!res)
			*nju = 0;
		res = nju;
		strcpy(res + strlen(res), buf);

		if (strchr(buf, '\n'))
			break;
	}

	if (res && strlen(res) > 0 && res[strlen(res) - 1] == '\n')
		res[strlen(res) - 1] = 0;
	if (res && strlen(res) > 0 && res[strlen(res) - 1] == '\r')
		res[strlen(res) - 1] = 0;


	return res;
}


int readUserlist() {
	char * path;

  struct passwd *pw;
	if (!(pw = getpwuid(getuid())))
		path = getenv("HOME");
	path = pw->pw_dir;

	char * path2 = "/.gg/userlist";
	char buffer[255];
	snprintf(buffer,255,"%s%s",path,path2);

	printf("KK readUserlist(): Opening userlist file: %s\n", buffer);

	FILE *f;
	char * buf;
	int i = 0;

	if (!(f = fopen(buffer, "r"))) {
		fprintf(stderr, "KK readUserlist(): Error opening userlist file");
		return -1;
		}

	userlist_count = 0;

	printf("KK readUserlist(): File opened successfuly\n");

	while ((buf = read_file(f))) {
		char *comment;

		if (buf[0] == '#') {
			free(buf);
			continue;
		}

		if (!strchr(buf, ';')) {
			if (!(comment = strchr(buf, ' '))) {
				free(buf);
				continue;
			}

			userlist[i].uin = strtol(buf, NULL, 0);

			if (!userlist[i].uin) {
				free(buf);
				continue;
			}

			userlist[i].first_name = NULL;
			userlist[i].last_name = NULL;
			userlist[i].nickname = NULL;
			userlist[i].anonymous = false;
			userlist[i].comment = strdup(++comment);
			userlist[i].mobile = NULL;
			userlist[i].ip = 0;
			userlist[i].port = 0;
			userlist[i].group = NULL;

		} else {
			char *first_name, *last_name, *nickname, *comment, *mobile, *group, *uin,
 *foo = buf;

			first_name = get_token(&foo, ';');
			last_name = get_token(&foo, ';');
/*			nickname = get_token(&foo, ';');
			comment = get_token(&foo, ';'); */
      comment = get_token(&foo, ';');
      nickname = get_token(&foo, ';');
			mobile = get_token(&foo, ';');
			group = get_token(&foo, ';');
			uin = get_token(&foo, ';');

      /* load groups */
/*
      if (group != NULL && QString::compare(group, "") != 0) {
        bool already = false;
        for (int f = 0; f < grouplist.size(); f++) {
          if (QString::compare(__c2q(grouplist[f].name), __c2q(group)) == 0) {
            already = true;
            break;
            }
          }

        if (!already) {
          grouplist.resize(grouplist.size()+1);
          if (grouplist.size() > 1)
            grouplist[grouplist.size()-1].number = grouplist[grouplist.size()-2].number + 1;
          else
            grouplist[grouplist.size()-1].number = 601;
          grouplist[grouplist.size()-1].name = strdup(group);
        }

      } */

			if (!uin || !(userlist[i].uin = strtol(uin, NULL, 0))) {
				free(buf);
				continue;
			}

			userlist[i].first_name = strdup(first_name);
			cp_to_iso((unsigned char *)userlist[i].first_name);
			userlist[i].last_name = strdup(last_name);
			cp_to_iso((unsigned char *)userlist[i].last_name);
			userlist[i].nickname = strdup(nickname);
			cp_to_iso((unsigned char *)userlist[i].nickname);
			userlist[i].comment = strdup(comment);
			cp_to_iso((unsigned char *)userlist[i].comment);
			userlist[i].mobile = strdup(mobile);
			userlist[i].group = strdup(group);
			cp_to_iso((unsigned char *)userlist[i].group);

			/* if the nickname isn't defined explicitly, try to guess it */
			if (QString::compare(userlist[i].nickname,"") == 0)
				if (QString::compare(userlist[i].comment,"") == 0)
					strcpy(userlist[i].nickname,userlist[i].first_name);
				else
					strcpy(userlist[i].nickname,userlist[i].comment);

		}

		free(buf);

		userlist[i].status = GG_STATUS_NOT_AVAIL;

		i++;
		if (i > userlist.size() - 2) {
			userlist.resize(i+1);
			userlist[i].description = NULL;
			}
	}

	userlist[i].uin = 0;
	userlist[i].comment = NULL;
	userlist[i].status = 0;

	userlist_count = i;

	fclose(f);

	return 0;

	}


void sigchldHndl (int whatever) {

 while ((wait3(NULL, WNOHANG, NULL)) > 0);
}


void eventRecvMsg(int msgclass, uin_t sender, unsigned char * msg, time_t time,int formats_count=0,struct gg_msg_format * formats=NULL) {
	if (isIgnored(sender)) return;

	/* check whether it's a system message */
	if (sender == 0) {
		if (msgclass <= config.sysmsgidx) {
		        std::cout << "KK Already had this message, ignoring" << std::endl;
			return;
			}
     config.sysmsgidx = msgclass;
			printf("KK System message index %d\n", msgclass);
			sender = config.uin;
		}

	char * nick;
	nick = UinToUser(sender);
	cp_to_iso(msg);

	if (config.logmessages && sender != config.uin)
		appendHistory(sender,msg,FALSE,time);

	int i; bool yup = FALSE;
	for (i = 0; i < MAX_CHATS; i++) {
		if (chats[i].uin == (unsigned int) sender) {
		yup = TRUE;
		break;
			}
		}

	if ((msgclass == GG_CLASS_CHAT) && (yup == true)) {
		if (formats_count !=0 && formats != NULL)
			chats[i].ptr->checkPresence(sender, msg, time, formats_count, formats);
		else
			chats[i].ptr->checkPresence(sender, msg, time);
  	return;
		}

	for (i = 0; i < pending.size(); i++)
		if (pending[i].uin == 0)
			break;

	if (i > pending.size() - 1) {
		pending.resize(pending.size()+1);
		printf("eventRecvMsg(): New buffer size: %d\n",pending.size());
		i=pending.size()-1;
		}

	pending[i].uin = sender;
	pending[i].msgclass = msgclass;
	pending[i].msg = new QString;
	pending[i].msg->append((char *)msg);

	printf("eventRecvMsg(): Message allocated to slot %d\n", i);
	printf("eventRecvMsg(): Got message from %d (%s) saying \"%s\"\n", sender, nick, msg);

	kadu->syncUserlist();
  kadu->sortUsers();
	dw->setMsg();

 	playSound(config.soundmsg);

  if (config.raise)
      kadu->showNormal();

	if (sender == config.uin)
			new rMessage("System", i);

	}

void playSound(char * sound) {
if (!config.playsound) return;

	if (!mute) {
	if ((QString::compare(sound,NULL) == 0) || (QString::compare(sound,"") == 0)) {
		fprintf(stderr,"KK No sound file specified?\n");
		return;
		}

	char path[511];
	pid_t nasz_pid;
	nasz_pid = fork();
if (nasz_pid == 0) {

if (config.playartsdsp) {
	if (config.soundvolctrl)
		snprintf(path, sizeof(path), "artsdsp %s -v %.2f %s", config.soundprog, config.soundvol, sound);
	else
		snprintf(path, sizeof(path), "artsdsp %s %s", config.soundprog, sound);
} else {
	if (config.soundvolctrl)
		snprintf(path, sizeof(path), "%s -v %.2f %s", config.soundprog, config.soundvol, sound);
	else	
		snprintf(path, sizeof(path), "%s %s", config.soundprog, sound);
	}

	system(path);
	exit(0);
} else {
struct sigaction sigact;
sigact.sa_handler = sigchldHndl;
sigact.sa_flags = 0;
sigact.sa_restorer = NULL;
if (sigaction(SIGCHLD,&sigact,NULL) < 0)
      perror("sigaction");
}
	}

}


void UinToUserlistEntry (uin_t uin, int new_status) {
	for (int i = 0; i < userlist.size(), userlist[i].uin != 0, userlist[i].nickname != NULL; i++) {
		if (userlist[i].uin == uin) {
			userlist[i].status = new_status;
			return;
			}
		}
	}

int GetStatusFromUserlist (unsigned int uin) {
	for (int i = 0; i < userlist.size(); i++) {
		if (userlist[i].uin == uin)
			return userlist[i].status;
	}

	return -1;
}

void ChangeUserStatus (unsigned int uin, int new_status) {
	int num = mylist->numItemsVisible();
	QString tmpstr;

	for (int i = 0; i < num; i++) {
		tmpstr = mylist->text(i);
	
		for (int j = 0; j < pending.size(); j++)
       if (pending[j].uin == uin) return;

		if (tmpstr.compare(__c2q(UinToUser(uin))) == 0) {

	QPixmap * gg_st;
	if (new_status == GG_STATUS_AVAIL)
		gg_st = new QPixmap((const char**)gg_act_xpm);
	else if (new_status == GG_STATUS_BUSY)
		gg_st = new QPixmap((const char**)gg_busy_xpm);
	else if (new_status == GG_STATUS_BUSY_DESCR)
		gg_st = new QPixmap((const char**)gg_busydescr_xpm);
	else if (new_status == GG_STATUS_NOT_AVAIL)
		gg_st = new QPixmap((const char**)gg_inact_xpm);
	else if (new_status == GG_STATUS_NOT_AVAIL_DESCR)
		gg_st = new QPixmap((const char**)gg_inactdescr_xpm);
  else if (new_status == GG_STATUS_AVAIL_DESCR)
    gg_st = new QPixmap((const char**)gg_actdescr_xpm);
	else if (new_status == GG_STATUS_INVISIBLE2)
		gg_st = new QPixmap((const char**)gg_invi_xpm);
	else if (new_status == GG_STATUS_INVISIBLE_DESCR)
		gg_st = new QPixmap((const char**)gg_invidescr_xpm);
	else
		gg_st = new QPixmap((const char**)gg_inact_xpm);

		mylist->changeItem(*gg_st, __c2q(UinToUser(uin)), i);
		delete gg_st;
			}
		}

	}

void ifNotify(uin_t uin, unsigned long status, unsigned long oldstatus)
{

    if (config.notifyglobal && config.notifies.contains(QString::number(uin)) && (status == GG_STATUS_AVAIL ||
	status == GG_STATUS_AVAIL_DESCR || status == GG_STATUS_BUSY || status == GG_STATUS_BUSY_DESCR) &&
	(oldstatus == GG_STATUS_NOT_AVAIL || oldstatus == GG_STATUS_NOT_AVAIL_DESCR || oldstatus == GG_STATUS_INVISIBLE ||
	oldstatus == GG_STATUS_INVISIBLE_DESCR || oldstatus == GG_STATUS_INVISIBLE2))
	{
	std::cout << "KK Notify about user" << std::endl;
    
	if (config.notifydialog) {		
	    char mes[512];
	    snprintf(mes, sizeof(mes), i18n("User %s is available"), UinToUser(uin));
	    QMessageBox::information(0, i18n("User notify"), mes);		
	    }

	if (config.notifysound)
	    playSound(config.soundnotify);

	}
}


void eventGotUserlist(struct gg_event * e) {
    struct gg_notify_reply *n = e->event.notify;
    unsigned long oldstatus;

    int i;
	while (n->uin) {
		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == n->uin) break;

    if (i == userlist.size()) {
      std::cout << "KK eventGotUserlist(): buddy " << n->uin << " not in list. Damned server!\n";
  		gg_remove_notify(&sess, n->uin);
      if (n++ == 0)
        return;
      }


		userlist[i].ip = n->remote_ip;
		userlist[i].port = n->remote_port;

    oldstatus = GetStatusFromUserlist(n->uin);
    
    if (n->status != GG_STATUS_NOT_AVAIL)
      UinToUserlistEntry(n->uin, n->status);
    else if (n->status == GG_STATUS_NOT_AVAIL && GetStatusFromUserlist(n->uin) == GG_STATUS_NOT_AVAIL)
      UinToUserlistEntry(n->uin, GG_STATUS_INVISIBLE2);
    else
      UinToUserlistEntry(n->uin, GG_STATUS_NOT_AVAIL);

//    ChangeUserStatus(n->uin, n->status);

		if (n->status == GG_STATUS_AVAIL)
			printf("KK eventGotUserlist(): User %d went online\n", n->uin);
		else if (n->status == GG_STATUS_BUSY)
			printf("KK eventGotUserlist(): User %d went busy\n", n->uin);
    else if (n->status == GG_STATUS_NOT_AVAIL && GetStatusFromUserlist(n->uin) == GG_STATUS_NOT_AVAIL)
			printf("KK eventGotUserlist(): User %d went offline (probably invisible ;))\n", n->uin);
    else if (n->status == GG_STATUS_NOT_AVAIL && GetStatusFromUserlist(n->uin) != GG_STATUS_NOT_AVAIL)
			printf("KK eventGotUserlist(): User %d went offline\n", n->uin);
    else
      printf("KK eventGotUserlist(): Unknown status for user %d: %d\n", n->uin, n->status);

        ifNotify(n->uin, n->status, oldstatus);
		n++;

			if (userlist[i].description != NULL) {
//				delete userlist[i].description;
        userlist[i].description->truncate(0);
//				userlist[i].description = NULL;
				}
	}

    kadu->syncUserlist();
    
}

void eventGotUserlistWithDescription(struct gg_event * e) {
	struct gg_notify_reply *n = e->event.notify_descr.notify;

  bool matched = false;
  unsigned long oldstatus;
  
  for (int i = 0; i < userlist.size(); i++)
    if (userlist[i].uin == n->uin) {
      matched = true;
      break;
      }
  if (!matched) {
     // ignore!
      std::cout << "KK eventGotUserlist(): buddy " << n->uin << " not in list. Damned server!\n";
  		gg_remove_notify(&sess, n->uin);
      return;
      }

	int i;

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == n->uin) break;
		userlist[i].ip = n->remote_ip;
		userlist[i].port = n->remote_port;

		oldstatus = userlist[i].status;
		
		if (userlist[i].description != NULL)
			userlist[i].description->truncate(0);
		else
			userlist[i].description = new QString;

		if (n->status == GG_STATUS_BUSY_DESCR) {
			printf("KK eventGotUserlistWithDescription(): User %d went busy with descr.\n", n->uin);
			userlist[i].description->append(__c2q(e->event.notify_descr.descr));
			UinToUserlistEntry(n->uin, GG_STATUS_BUSY_DESCR);
//			ChangeUserStatus(n->uin, GG_STATUS_BUSY_DESCR);
			} else if (n->status == GG_STATUS_NOT_AVAIL_DESCR) {
			printf("KK eventGotUserlistWithDescription(): User %d went offline with descr.\n", n->uin);
			userlist[i].description->append(__c2q(e->event.notify_descr.descr));
//			ChangeUserStatus(n->uin, GG_STATUS_NOT_AVAIL_DESCR);
			UinToUserlistEntry(n->uin, GG_STATUS_NOT_AVAIL_DESCR);
			} else if (n->status == GG_STATUS_AVAIL_DESCR) {
			printf("KK eventGotUserlistWithDescription(): User %d went online with descr.\n", n->uin);
			userlist[i].description->append(__c2q(e->event.notify_descr.descr));
//			ChangeUserStatus(n->uin, GG_STATUS_AVAIL_DESCR);
			UinToUserlistEntry(n->uin, GG_STATUS_AVAIL_DESCR);
			} else if (n->status == GG_STATUS_INVISIBLE_DESCR) {
			printf("KK eventGotUserlistWithDescription(): User %d went invisible with descr.\n", n->uin);
			userlist[i].description->append(__c2q(e->event.notify_descr.descr));
//			ChangeUserStatus(n->uin, GG_STATUS_INVISIBLE_DESCR);
			UinToUserlistEntry(n->uin, GG_STATUS_INVISIBLE_DESCR);



    }

    kadu->syncUserlist();

    ifNotify(n->uin, n->status, oldstatus);
}


void eventStatusChange(struct gg_event * e) {
  std::cout << "KK eventStatusChange(): User " << e->event.status.uin << " went " << e->event.status.status << std::endl;

    int i;
    unsigned long oldstatus;
    	
  bool matched = false;
  for (int i = 0; i < userlist.size(); i++)
    if (userlist[i].uin == e->event.status.uin) {
      matched = true;
      break;
      }
  if (!matched) {
     // ignore!
      std::cout << "KK eventGotUserlist(): buddy " << e->event.status.uin << " not in list. Damned server!\n";
  		gg_remove_notify(&sess, e->event.status.uin);
      return;
      }


	if (e->event.status.status == GG_STATUS_AVAIL) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_AVAIL);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_AVAIL);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		oldstatus = userlist[i].status;
		
		if (userlist[i].description != NULL) {
      userlist[i].description->truncate(0);
//			delete userlist[i].description;
			userlist[i].description = NULL;
			}

		}
	else if (e->event.status.status == GG_STATUS_AVAIL_DESCR) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_AVAIL_DESCR);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_AVAIL_DESCR);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL)
			userlist[i].description->truncate(0);
		else
			userlist[i].description = new QString;

		userlist[i].description->append(__c2q(e->event.status.descr));

		}
	else if (e->event.status.status == GG_STATUS_BUSY) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_BUSY);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_BUSY);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL) {
      userlist[i].description->truncate(0);
//			delete userlist[i].description;
			userlist[i].description = NULL;
			}

		}
	else if (e->event.status.status == GG_STATUS_BUSY_DESCR) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_BUSY_DESCR);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_BUSY_DESCR);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL)
			userlist[i].description->truncate(0);
		else
			userlist[i].description = new QString;

		userlist[i].description->append(__c2q(e->event.status.descr));

		}
	else if (e->event.status.status == GG_STATUS_NOT_AVAIL) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_NOT_AVAIL);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_NOT_AVAIL);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;
		userlist[i].ip = 0;
		userlist[i].port = 0;

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL) {
      userlist[i].description->truncate(0);
//			delete userlist[i].description;
			userlist[i].description = NULL;
			}

		}
  	else if (e->event.status.status == GG_STATUS_INVISIBLE_DESCR) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_INVISIBLE_DESCR);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_INVISIBLE_DESCR);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL)
			userlist[i].description->truncate(0);
		else
			userlist[i].description = new QString;

		userlist[i].description->append(__c2q(e->event.status.descr));

		}
  else if (e->event.status.status == GG_STATUS_NOT_AVAIL_DESCR) {
//		ChangeUserStatus(e->event.status.uin, GG_STATUS_NOT_AVAIL_DESCR);
		UinToUserlistEntry(e->event.status.uin, GG_STATUS_NOT_AVAIL_DESCR);

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;

		if (userlist[i].description != NULL)
			userlist[i].description->truncate(0);
		else
			userlist[i].description = new QString;

		userlist[i].description->append(__c2q(e->event.status.descr));

		for (i = 0; i < userlist.size(); i++)
			if (userlist[i].uin == e->event.status.uin) break;
		userlist[i].ip = 0;
		userlist[i].port = 0;
		}

  kadu->syncUserlist();

    ifNotify(e->event.status.uin, e->event.status.status, oldstatus);
}

void kadu_debug(int debuglevel, char * message) {
//		fprintf(stderr, "Debug type %i: %s\n", debuglevel, message);
	;
}


void cp_to_iso(unsigned char *buf)
{
        while (*buf) {
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == 140) *buf = '';
                if (*buf == 156) *buf = '';
                if (*buf == 143) *buf = '';
                if (*buf == 159) *buf = '';

/*                if (*buf != 13 && *buf != 10 && (*buf < 32 || (*buf > 127 && *buf < 160)))
                        *buf = '?';*/

                buf++;
        }
}

void iso_to_cp(unsigned char *buf)
{
        while (*buf) {
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                if (*buf == (unsigned char)'') *buf = '';
                buf++;
        }
}

void ackHandler(int seq) {
        int i;
        for (i = 0; i < MAX_ACK; i++) {
     if (acks[i].seq == seq)
                                        acks[i].ptr->gotAck();
                }
}

