/***************************************************************************
                          expimp.cpp  -  description
                             -------------------
    begin                : Thu Feb 14 2002
    copyright            : (C) 2002 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
extern struct config config;
extern QArray<userlist> userlist;
extern int write_userlist(char *);
extern int userlist_count;
extern gg_session sess;
extern MyListBox * mylist;
extern Kadu * kadu;

UserlistImport::UserlistImport(QDialog *parent, const char *name) : QDialog (parent, name) {
	this->resize(450,330);
	this->setCaption(i18n("Import userlist"));	
	this->setWFlags(Qt::WDestructiveClose);

		QGridLayout * grid = new QGridLayout(this,2,2,3,3);
		
		results = new QListView(this);
		
		KIconLoader *loader = KGlobal::iconLoader();

		fetchbtn = new QPushButton(this);
		fetchbtn->setIconSet(QIconSet( loader->loadIcon("connect_creating", KIcon::Small) ));
		fetchbtn->setText(i18n("&Fetch userlist"));
		QObject::connect(fetchbtn, SIGNAL( clicked() ), this, SLOT( startTransfer() ));

		QPushButton * savebtn = new QPushButton(this);
		savebtn->setIconSet(QIconSet( loader->loadIcon("filesave", KIcon::Small) ));
		savebtn->setText(i18n("&Save results"));
		QObject::connect(savebtn, SIGNAL( clicked() ), this, SLOT( updateUserlist() ));

		results->addColumn(i18n("UIN"));
		results->addColumn(i18n("Nickname"));
		results->addColumn(i18n("Disp. nick"));
		results->addColumn(i18n("Name"));
		results->addColumn(i18n("Surname"));
		results->addColumn(i18n("Mobile no."));
		results->addColumn(i18n("Group"));
		results->setAllColumnsShowFocus(true);


		grid->addMultiCellWidget(results,0,0,0,1);
		grid->addWidget(fetchbtn,1,0);
		grid->addWidget(savebtn,1,1);

	this->show();

	}

void UserlistImport::startTransfer() {
		if (!(gg_http = gg_userlist_get(config.uin, config.password, 1))) {
		fprintf(stderr, "KK UserlistImport: gg_userlist_get() failed\n");
		QMessageBox::critical(this, "Import error", i18n("The application encountered an internal error\nThe import was unsuccessful") );
		return;
		}

		fetchbtn->setEnabled(false);
		stimer = new QTimer(this);
		QObject::connect(stimer, SIGNAL(timeout()), this, SLOT(socketEvent()));		
		stimer->start(50);
}

void UserlistImport::closeEvent(QCloseEvent * e) {
	if (!struct_freed)
		gg_userlist_get_free(gg_http);
	QWidget::closeEvent(e);
	}

void UserlistImport::updateUserlist() {
      int i, j, k;
      bool add = true;
      for (i = 0; i < importedusers.size(); i++) {
        for (j = 0; j < userlist.size(); j++) {
          if (importedusers[i].uin == userlist[j].uin)
            add = false;
          }

      if (add) {
//       cout << "I should add " << importedusers[i].nickname << endl;
       for (k = 0; k < userlist.size(); k++) {
        if (userlist[k].uin == 0)
          break;
        }
       if (k >= userlist.size() - 1) {
        userlist.resize(userlist.size()+1);
        userlist[userlist.size()-1].uin=0;
        }

//        cout << "I guess k=" << k << " and userlist.size()=" << userlist.size() << endl;
        userlist[k].nickname = importedusers[i].nickname;
        userlist[k].first_name = importedusers[i].first_name;
        userlist[k].last_name = importedusers[i].last_name;
        userlist[k].comment = importedusers[i].comment;
        userlist[k].group = importedusers[i].group;
        userlist[k].mobile = importedusers[i].mobile;
        userlist[k].description = NULL;
        userlist[k].uin = importedusers[i].uin;
      }

      add = true;
        }

      kadu->syncUserlist();

			userlist_count = 1;
			while (userlist[userlist_count].uin != 0) userlist_count++;			

			uin_t *uins;
			uins = (uin_t *) malloc(userlist.size() * sizeof(uin_t));
	
			for (i = 0; i < userlist.size(); i++)
				uins[i] = userlist[i].uin;

			gg_notify(&sess, uins, userlist_count);
			printf("KK send_userlist(): Userlist sent\n");

			write_userlist(NULL);
    	printf("KK Wrote userlist\n");
		
			free(uins);
			
	}

void UserlistImport::socketEvent() {
		FD_ZERO(&rd);
		FD_ZERO(&wd);
		bool dis2 = false;

		if ((gg_http->check & GG_CHECK_READ))
			FD_SET(gg_http->fd, &rd);
		if ((gg_http->check & GG_CHECK_WRITE))
			FD_SET(gg_http->fd, &wd);

		tv.tv_sec = 0;
		tv.tv_usec = 500;

		ret = select(gg_http->fd + 1, &rd, &wd, NULL, &tv);

		if (ret < 1) {
			return;
		} else { // begin main block
			fprintf(stderr, "KK ImportUserlist::socketEvent(): data on socket\n");			

	if (gg_http->state == GG_STATE_DONE && gg_http->data == NULL) {
		fprintf(stderr, "KK ImportUserlist::socketEvent(): No results. Exit.\n");
		QMessageBox::information(this, "No results", i18n("Your action yielded no results") );
		fetchbtn->setEnabled(true);
		stimer->stop();
		struct_freed = true;
		gg_userlist_get_free(gg_http);
		return;
		}

	 if (gg_userlist_get_watch_fd(gg_http) < 0) {
		stimer->stop();
		fetchbtn->setEnabled(true);
		fprintf(stderr,"KK ImportUserlist::socketEvent(): gg_userlist_get_watch_fd() error. bailing out.\n");
		QMessageBox::critical(this, "Import error", i18n("The application encountered a network error\nThe import was unsuccessful") );
		struct_freed = true;
		gg_userlist_get_free(gg_http);
		return;
	}
	if (gg_http->state == GG_STATE_ERROR) {
		stimer->stop();
		fetchbtn->setEnabled(true);
		fprintf(stderr,"KK ImportUserlist::socketEvent(): gg_userlist_get_watch_fd() error. bailing out.\n");
		QMessageBox::critical(this, "Import error", i18n("The application encountered a network error\nThe import was unsuccessful") );
		struct_freed = true;
		gg_userlist_get_free(gg_http);
		return;
		}


	if (gg_http->state == GG_STATE_DONE) {
		fetchbtn->setEnabled(true);
	  fprintf(stderr,"Done\n");
		stimer->stop();
		QStringList strlist;
		strlist = QStringList::split("\r\n",(char *)gg_http->data,true);
		fprintf(stderr, "! %d !\n", strlist.count());		
		fprintf(stderr, "%s\n", gg_http->data);
		QStringList fieldlist;
		QString tmparray[7];
		QListViewItem * qlv;
				int i, j;
				QStringList::Iterator it, it2;

        for ((it = strlist.begin()), (i = 1); it != strlist.end(), i < strlist.count(); ++it, i++ ) {
						fieldlist = QStringList::split(";",*it,true);
						for ((it2 = fieldlist.begin()), (j = 1); it2 != fieldlist.end(), j < fieldlist.count(); ++it2, j++) {
               printf("%s ",(*it2).latin1() );
							 tmparray[j-1] = (*it2);
							}						

						importedusers.resize(importedusers.size()+1);
						importedusers[i-1].first_name = strdup(tmparray[0].local8Bit());
						importedusers[i-1].last_name = strdup(tmparray[1].local8Bit());
						importedusers[i-1].nickname = strdup(tmparray[2].local8Bit());
						importedusers[i-1].comment = strdup(tmparray[3].local8Bit());
						importedusers[i-1].mobile = strdup(tmparray[4].local8Bit());
						importedusers[i-1].group = strdup(tmparray[5].local8Bit());
						if (tmparray[6])
							importedusers[i-1].uin = tmparray[6].toInt();
						else
							importedusers[i-1].uin = 0;

						importedusers[i-1].status = GG_STATUS_NOT_AVAIL;

						qlv = new QListViewItem(results, tmparray[6], __c2q(tmparray[2]), __c2q(tmparray[3]), __c2q(tmparray[0]), __c2q(tmparray[1]), tmparray[4], __c2q(tmparray[5]));


            printf( "\n%s \n", (*it).latin1() );
						

        }


		struct_freed = true;
		gg_userlist_get_free(gg_http);
		return;

		}

		} // end main block
	}







UserlistExport::UserlistExport(QDialog *parent, const char *name) : QDialog (parent, name) {
	this->setCaption(i18n("Export userlist"));	
	this->setWFlags(Qt::WDestructiveClose);

	KIconLoader *loader = KGlobal::iconLoader();

	QGridLayout * grid = new QGridLayout(this,3,1,3,3);

	int i = 0;
	while (userlist[i].uin != 0)
	    i++;
	char message[100];
	snprintf(message, sizeof(message), "%d entries will be exported",i);

	QLabel * clabel = new QLabel(this);
	clabel->setText(message);

	sendbtn = new QPushButton(this);
	sendbtn->setText(i18n("&Send userlist"));
	sendbtn->setIconSet(QIconSet( loader->loadIcon("connect_creating", KIcon::Small) ));

	QPushButton * closebtn = new QPushButton(this);
	closebtn->setText(i18n("&Close window"));
	closebtn->setIconSet(QIconSet( loader->loadIcon("stop", KIcon::Small) ));

	QObject::connect(closebtn, SIGNAL( clicked() ), this, SLOT( close() ));

	grid->addWidget(clabel,0,0);
	grid->addWidget(sendbtn,1,0);
	grid->addWidget(closebtn,2,0);

	QObject::connect(sendbtn, SIGNAL( clicked() ), this, SLOT( startTransfer() ) );
	this->show();
}

void UserlistExport::startTransfer() {
		QString contacts;
		int i = -1;
		char t_uin[12];
		while(userlist[++i].uin != 0) {
			contacts += __c2q(userlist[i].first_name);
			contacts += __c2q(";");
			contacts += __c2q(userlist[i].last_name);
			contacts += __c2q(";");
			contacts += __c2q(userlist[i].nickname);
			contacts += __c2q(";");
			contacts += __c2q(userlist[i].comment);
			contacts += __c2q(";");
			contacts += __c2q(userlist[i].mobile);
			contacts += __c2q(";");
			contacts += __c2q(userlist[i].group);
			contacts += __c2q(";");
			snprintf(t_uin,sizeof(t_uin),"%d",userlist[i].uin);
			contacts += __c2q(t_uin);
			contacts += __c2q(";\r\n");
			}
		contacts.replace( QRegExp("(null)"), "" );


		char * con2;
		con2 = strdup(contacts.local8Bit());

		if (!(gg_http = gg_userlist_put(config.uin, config.password, con2, 1))) {
		fprintf(stderr, "KK UserlistExport: gg_userlist_put() failed\n");
		QMessageBox::critical(this, "Export error", i18n("The application encountered an internal error\nThe export was unsuccessful") );
		return;
		}

		sendbtn->setEnabled(false);
		stimer = new QTimer(this);
		QObject::connect(stimer, SIGNAL(timeout()), this, SLOT(socketEvent()));		
		stimer->start(50);
}

void UserlistExport::socketEvent() {
		FD_ZERO(&rd);
		FD_ZERO(&wd);
		bool dis2 = false;

		if ((gg_http->check & GG_CHECK_READ))
			FD_SET(gg_http->fd, &rd);
		if ((gg_http->check & GG_CHECK_WRITE))
			FD_SET(gg_http->fd, &wd);

		tv.tv_sec = 0;
		tv.tv_usec = 500;

		ret = select(gg_http->fd + 1, &rd, &wd, NULL, &tv);

		if (ret < 1) {
			return;
		} else { // begin main block

			fprintf(stderr, "KK ExportUserlist::socketEvent(): data on socket\n");			

	 if (gg_userlist_put_watch_fd(gg_http) < 0) {
		stimer->stop();
		sendbtn->setEnabled(true);
		fprintf(stderr,"KK ExportUserlist::socketEvent(): gg_userlist_put_watch_fd() error. bailing out.\n");
		QMessageBox::critical(this, "Export error", i18n("The application encountered a network error\nThe export was unsuccessful") );
		struct_freed = true;
		gg_userlist_put_free(gg_http);
		return;
	}
	if (gg_http->state == GG_STATE_ERROR) {
		stimer->stop();
		sendbtn->setEnabled(true);
		fprintf(stderr,"KK ExportUserlist::socketEvent(): gg_userlist_put_watch_fd() error. bailing out.\n");
		QMessageBox::critical(this, "Export error", i18n("The application encountered a network error\nThe export was unsuccessful") );
		struct_freed = true;
		gg_userlist_put_free(gg_http);
		return;
		}

	if (gg_http->state == GG_STATE_DONE) {
		sendbtn->setEnabled(true);
	  fprintf(stderr,"KK Export Done\n");
		stimer->stop();
		QMessageBox::information(this, "Export complete", i18n("Your userlist has been successfully exported to server") );
					
		struct_freed = true;
		gg_userlist_put_free(gg_http);
		return;


        }

		} // end main block
	}

void UserlistExport::closeEvent(QCloseEvent * e) {
	if (!struct_freed)
		gg_userlist_put_free(gg_http);
	QWidget::closeEvent(e);
	}

