/***************************************************************************
                          kadu.cpp  -  description
                             -------------------
    begin                : wto sie 21 18:35:52 CEST 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/*                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include "events.h"
#include "chat.h"
#include "search.h"

extern Kadu * kadu;
extern KApplication * a;
extern bool mute;
extern void ackHandler(int);
extern char * prepare_path(char *);
extern void UinToUserlistEntry (uin_t, int);
void iso_to_cp(unsigned char *);

bool userlist_sent = FALSE;
bool socket_active = FALSE;
bool disconnect_planned = FALSE;
int userlist_count = 0;
char tmprcvr [255];
int last_ping;
int last_read_event = -1;
bool timeout_connected = true;
bool i_wanna_be_invisible = true;
bool i_am_busy = false;
Operation * progresswindow;

struct timeval tv;
struct gg_event *e;
fd_set rd, wd;
int ret;

QTimer * connectimer;
QTimer * pingtimer;
QTimer * readevent;
MyListBox * mylist;
QComboBox * mycombo;
QLabel * statuslabel;
DockWidget * dw;
QPopupMenu * grpmenu;

QArray<userlist> userlist(10);
QArray<pending> pending(1);
struct chats chats[MAX_CHATS];
struct gg_session sess;
struct sigaction sigact;
struct config config;
struct acks acks[MAX_ACK];
struct gg_dcc * dccsock;
QArray<uin_t> ignored;
QArray<groups> grouplist;
struct gg_login_params loginparams;

/* our own description container */
QString own_description;

/* a monstrous constructor so Kadu would take longer to start up */
Kadu::Kadu(QWidget *parent, const char *name) : QWidget (parent, name)
{
/* timers, cause event loops and QSocketNotifiers suck. */
pingtimer = new QTimer;
connectimer = new QTimer;
readevent = new QTimer;

/* initalize our closeEvent workaround */
close_permitted = false;

/* blinker */
blinkOn = false;
doBlink = false;

/* we're not auto away yet */
autoawayed = false;

/* we don't hammer the server if it's busy yet */
autohammer = false;

/* another API change, another hack */
memset(&loginparams, 0, sizeof(loginparams));
loginparams.async = 1;

/* active group, 600 is all groups */
activegrpno = 600;

int g;
/* empty buffers, g < 1 if we're clean & lucky */
for (g = 0; g < userlist.size(); g++)
	userlist[g].description = NULL;

for (g = 0; g < pending.size(); g++)
	pending[g].uin = 0;

for (g = 0; g < MAX_ACK; g++)
	acks[g].seq = 0;

for (g = 0; g < MAX_CHATS; g++)
	chats[g].uin = 0;

for (g = 0; g < ignored.size(); g++)
	ignored[g] = 0;
	
/* first read our own config file... */
fprintf(stderr,"KK Kadu(): Touching config file...\n");
KConfig * konf;
konf = new KConfig(prepare_path("kadu.conf"));
konf->setGroup("Global");
config.uin = konf->readNumEntry("UIN",0);
config.password = pwHash(konf->readEntry("Password",""));
//config.password = strdup(konf->readEntry("Password",""));
fprintf(stderr,"KK Read user data: uin %d password %s\n",config.uin,config.password);
config.soundprog = strdup(konf->readEntry("SoundPlayer",""));
config.soundmsg = strdup(konf->readEntry("Message_sound",""));
config.soundvolctrl = konf->readBoolEntry("VolumeControl",false);
config.soundvol = konf->readDoubleNumEntry("SoundVolume",1.0);
config.soundchat = strdup(konf->readEntry("Chat_sound",""));
config.defaultstatus = konf->readNumEntry("DefaultStatus",0);
config.logmessages = konf->readBoolEntry("Logging",true);
config.savegeometry = konf->readBoolEntry("SaveGeometry",true);
config.playsoundchat = konf->readBoolEntry("PlaySoundChat",true);
config.playsoundchatinvisible = konf->readBoolEntry("PlaySoundChatInvisible",true);
config.playsound = konf->readBoolEntry("PlaySound",false);
config.playartsdsp = konf->readBoolEntry("PlaySoundArtsDsp",false);
config.sysmsgidx = konf->readNumEntry("SystemMsgIndex",0);
config.autoaway = konf->readBoolEntry("AutoAway", false);
config.autoawaytime = konf->readNumEntry("AutoAwayTime", 300);
config.allowdcc = konf->readBoolEntry("AllowDCC",false);
config.dock = konf->readBoolEntry("UseDocking",true);
config.raise = konf->readBoolEntry("AutoRaise",false);

if (config.savegeometry) {
  QRect * geometry;
  geometry = new QRect;
  *geometry = konf->readRectEntry("Geometry");
  fprintf(stderr,"KK Setting geometry to %d %d %d %d\n",geometry->x(), geometry->y(), geometry->width(), geometry->height());
  this->setGeometry(*geometry);
  delete geometry;
} else {
  resize(130,250);
  this->move(this->maximumSize().width() - this->x(), this->maximumSize().height() - this->y());
}

konf->setGroup("SMS");
config.smsapp = strdup(konf->readEntry("SmsApp",""));
config.smscustomconf = konf->readBoolEntry("UseCustomString",false);
config.smsconf = strdup(konf->readEntry("SmsString",""));

konf->setGroup("Other");
config.emoticons = konf->readBoolEntry("UseEmoticons",false);
config.autosend = konf->readBoolEntry("AutoSend",false);
config.scrolldown = konf->readBoolEntry("ScrollDown",true);
config.emoticonspath = strdup(konf->readEntry("EmoticonsPath",""));
config.chatprune = konf->readBoolEntry("ChatPrune",false);
config.chatprunelen = konf->readNumEntry("ChatPruneLen",20);

konf->setGroup("Notify");
config.soundnotify = strdup(konf->readEntry("NotifySound",""));
config.notifyglobal = konf->readBoolEntry("NotifyStatusChange",false);
config.notifydialog = konf->readBoolEntry("NotifyWithDialogBox",false);
config.notifysound = konf->readBoolEntry("NotifyWithSound",false);
config.notifies = konf->readListEntry("NotifyUsers");

konf->setGroup("Proxy");
config.useproxy = konf->readBoolEntry("UseProxy",false);
config.proxyaddr = strdup(konf->readEntry("ProxyHost",""));
config.proxyport = konf->readNumEntry("ProxyPort",0);

konf->setGroup("Colors");
config.colors.userboxBgR = konf->readNumEntry("UserboxBgR",255);
config.colors.userboxBgG = konf->readNumEntry("UserboxBgG",255);
config.colors.userboxBgB = konf->readNumEntry("UserboxBgB",255);
config.colors.userboxFgR = konf->readNumEntry("UserboxFgR",0);
config.colors.userboxFgG = konf->readNumEntry("UserboxFgG",0);
config.colors.userboxFgB = konf->readNumEntry("UserboxFgB",0);
config.colors.userboxFont = strdup(konf->readEntry("UserboxFont","sans-serif"));
config.colors.userboxFontSize = konf->readNumEntry("UserboxFontSize",12);

/* no need for it anymore */
delete konf;

/* use dock icon? */
if (config.dock)
	dw = new DockWidget(this);

/* read the userlist */
readUserlist();
/* read config, ignores actually, don't wanna rename it */
readConfig();

/* DCC */
if (config.allowdcc) {
	prepareDcc();
	}

/*char buf[255];
char buf2[255];
strncpy(buf,"Kadu:",255);
snprintf(buf2,255,"%s %d",buf,config.uin);*/
QString buf;
buf.append("Kadu: ");
buf.append(QString::number(config.uin));

/* use proxy? */
if (config.useproxy) {
  gg_proxy_host = config.proxyaddr;
  gg_proxy_port = config.proxyport;
  gg_proxy_enabled = 1;
  }

/* a newbie? */
if (config.uin == 0) {
 QString path_;
 path_ = prepare_path("");
 mkdir(path_.local8Bit(), 0700);
 path_.append("/history/");
 mkdir(path_.local8Bit(), 0700);
 switch( QMessageBox::information( kadu, "Kadu",
  i18n("You don't have a config file.\nWhat would you like to do?"),"New UIN", "Configure", "Cancel", 0, 1) ) {
 case 1: // Configure
			new ConfigDialog;
			break;
 case 0: // Register
			new Register;
			break;
 case 2: // Nothing
			break;
	}
  this->setCaption("Kadu: new user");
	} else
	this->setCaption(i18n("Kadu: %1").arg(config.uin));

/* initialize and configure userbox */
mylist = new MyListBox(this);
mylist->setPaletteBackgroundColor(QColor(config.colors.userboxBgR,config.colors.userboxBgG,config.colors.userboxBgB));
mylist->setPaletteForegroundColor(QColor(config.colors.userboxFgR,config.colors.userboxFgG,config.colors.userboxFgB));
mylist->QListBox::setFont(QFont(config.colors.userboxFont, config.colors.userboxFontSize));

QPixmap qp_inact((const char **)gg_inact_xpm);
for (int i = 0; i < userlist.count(), userlist[i].uin != 0; i++) {
	mylist->insertItem(qp_inact, __c2q(userlist[i].nickname));
}

/* start auto away. yes, even if it's disabled. this way enabling it will work at run-time */
autoaway = new QTimer(this);
autoaway->start(config.autoawaytime * 1000);
connect(autoaway, SIGNAL( timeout() ), this, SLOT( autoAway() ));

connect(mylist, SIGNAL( doubleClicked(QListBoxItem *)), this, SLOT( sendMessage(QListBoxItem *) ) );
connect(mylist, SIGNAL( rightButtonClicked(QListBoxItem *, const QPoint &)),
	this, SLOT( listPopupMenu(QListBoxItem *)));

/* more internal initialization. */
mycombo = new QComboBox (this);
mycombo->setGeometry(10, 220, 100, 20);
mycombo->insertItem("Online", 0);
mycombo->insertItem("Away", 1);
mycombo->insertItem("Invisible", 2);
mycombo->insertItem("Offline", 3);

#warning Using own descriptive status is buggy
mycombo->insertItem(QPixmap((const char**)gg_info_xpm), "Away  ", 4);
mycombo->setCurrentItem(3);
mycombo->setFont(QFont(config.colors.userboxFont, config.colors.userboxFontSize));
connect(mycombo, SIGNAL(activated(const QString &)), this, SLOT(slotHandleState(const QString &)) );

statuslabel = new QLabel (this);
statuslabel->setPixmap(QPixmap((const char**)gg_inact_xpm) );

/* guess what */
createMenu();

QGridLayout * grid = new QGridLayout (this,3,3);
grid->addMultiCellWidget(mmb,0,0,0,2);
grid->addMultiCellWidget(mylist, 1, 1, 0, 2);
grid->addWidget(mycombo, 2, 0);
grid->addWidget(statuslabel, 2, 2);
grid->setColStretch(0, 3);
grid->setColStretch(1, 1);
grid->setColStretch(2, 1);

/* dirty workaround for multiple showEvents */
commencing_startup = true;

this->show();

/* set an offline icon */
this->setIcon( QPixmap((const char**)gg_inact_xpm) );
this->repaint();

}

/* reimplemented, to auto login */
void Kadu::showEvent (QShowEvent * e) {
QWidget::showEvent(e);

if (config.defaultstatus == 1 && commencing_startup) {
	setOnline();
	autohammer = true;
  commencing_startup = false;
	}
else if (config.defaultstatus == 3 && commencing_startup) {
	setInvisible();
	autohammer = true;
  commencing_startup = false;
	}

}

void Kadu::blink() {
  if (!doBlink && socket_active) {
    switch (loginparams.status&(~GG_STATUS_FRIENDS_MASK)) {
      case GG_STATUS_AVAIL:
        statuslabel->setPixmap(QPixmap((const char**)gg_act_xpm) );
        break;
      case GG_STATUS_INVISIBLE:
        statuslabel->setPixmap(QPixmap((const char**)gg_invi_xpm) );
        break;
      case GG_STATUS_BUSY:
        statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
        break;
      case GG_STATUS_BUSY_DESCR:
        statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
        break;
      case GG_STATUS_AVAIL_DESCR:
        statuslabel->setPixmap(QPixmap((const char**)gg_actdescr_xpm) );
        break;
      }
    return;
  } else if (!doBlink && !socket_active) {
    statuslabel->setPixmap(QPixmap((const char**)gg_inact_xpm) );
    return;
  }

  if (blinkOn) {
    statuslabel->setPixmap(QPixmap((const char**)gg_inact_xpm) );
    blinkOn = false;
  } else {
    switch (loginparams.status&(~GG_STATUS_FRIENDS_MASK)) {
      case GG_STATUS_AVAIL:
        statuslabel->setPixmap(QPixmap((const char**)gg_act_xpm) );
        break;
      case GG_STATUS_INVISIBLE:
        statuslabel->setPixmap(QPixmap((const char**)gg_invi_xpm) );
        break;
      case GG_STATUS_BUSY:
        statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
        break;
      case GG_STATUS_BUSY_DESCR:
        statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
        break;
      case GG_STATUS_AVAIL_DESCR:
        statuslabel->setPixmap(QPixmap((const char**)gg_actdescr_xpm) );
        break;
      }
    blinkOn = true;
    }

  QTimer::singleShot(1000, this, SLOT( blink() ));

  }

/* dcc initials */
void prepareDcc(void) {
	dccsock = gg_dcc_socket_create(config.uin, 0);

	if (!dccsock) {
				perror("DCC");
				gg_dcc_free(dccsock);
				QMessageBox::warning(kadu, "", i18n("Couldn't create DCC socket.\nDirect connections disabled.") );		
				return;
				}

  gg_dcc_port = dccsock->port;
}

bool Kadu::userInActiveGroup(uin_t uin) {
  int i, j;

  if (grouplist.size() == 0)
    return true;

  for (i = 0; i < grouplist.size(); i++)
    if (grouplist[i].number == activegrpno)
       break;

  for (j = 0; j < userlist.size(); j++)
    if (userlist[j].uin == uin)
       break;

  if (userlist[j].group == NULL && activegrpno == 600)
    return true;
  else if (userlist[j].group == NULL && activegrpno != 600)
    return false;
  else if (strcmp(userlist[j].group, grouplist[i].name) == 0)
     return true;
  else if (activegrpno == 600)
     return true;
  else
    return false;

}

/* Userlist code is very dirty, so to avoid double messages we sync the
   userlist each time. Sorry, poor CPU folks! */

void Kadu::syncUserlist() {
//KIconLoader *loader = KGlobal::iconLoader();
bool hasPendingMesg = false;
int i,j;
mylist->clear();
for (i = 0; i < userlist.size(); i++) {

  /*
  if (!userInActiveGroup(userlist[i].uin))
    continue;
  */

	if (userlist[i].nickname == NULL || userlist[i].uin == 0)
		break;

	for (j = 0; j < pending.size(); j++) {
		if (pending[j].uin == userlist[i].uin) {
//			mylist->insertItem(QPixmap(loader->loadIcon("mail_generic", KIcon::Small)), __c2q(userlist[i].nickname));
      mylist->insertItem(QPixmap((const char **)gg_msg_xpm), __c2q(userlist[i].nickname));
			hasPendingMesg = true;			
			break;
			}
		}

	if (hasPendingMesg) {
		hasPendingMesg = false;
		continue;
		} else {

	switch (userlist[i].status) {
		case GG_STATUS_AVAIL:
//      mylist->insertItem(userlist[i].nickname);
			mylist->insertItem(QPixmap((const char **)gg_act_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_AVAIL_DESCR:
			mylist->insertItem(QPixmap((const char **)gg_actdescr_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_NOT_AVAIL:
			mylist->insertItem(QPixmap((const char **)gg_inact_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_BUSY:
			mylist->insertItem(QPixmap((const char **)gg_busy_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_BUSY_DESCR:
			mylist->insertItem(QPixmap((const char **)gg_busydescr_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_NOT_AVAIL_DESCR:
			mylist->insertItem(QPixmap((const char **)gg_inactdescr_xpm), __c2q(userlist[i].nickname));			
			break;
		case GG_STATUS_INVISIBLE_DESCR:
			mylist->insertItem(QPixmap((const char **)gg_invidescr_xpm), __c2q(userlist[i].nickname));			
      break;
		case GG_STATUS_INVISIBLE2:
			mylist->insertItem(QPixmap((const char **)gg_invi_xpm), __c2q(userlist[i].nickname));			
			break;
		default:
			mylist->insertItem(QPixmap((const char **)gg_inact_xpm), __c2q(userlist[i].nickname));			
		}
	}

	}	

}


/* don't worry if you can't follow this. I can't either. */
/* should brew beer, sorts users instead */
void Kadu::sortUsers() {
	unsigned int j, k = 0;
	bool item_selected = 0;
	for (unsigned int i = 0; i < mylist->count(); i++) {
		if (mylist->isSelected(i)) {
				item_selected = i;
				break;
			}
		} // int i

	for (unsigned int i = 0; i < mylist->count(); i++) {
		 for (j = 0; j < userlist.size(); j++) {
          if (QString::compare(__c2q(userlist[j].nickname), mylist->item(i)->text()) == 0)
				break;
			} //int j
		if (userlist[j].status  == GG_STATUS_NOT_AVAIL_DESCR) {
			QPixmap * gg_st = new QPixmap((const char**)gg_inactdescr_xpm);		
			QString tmpstr;
			tmpstr = mylist->item(i)->text();
			mylist->changeItem(*gg_st, tmpstr, i);
			delete gg_st;				
			
		} else
		if (userlist[j].status	== GG_STATUS_AVAIL || userlist[j].status == GG_STATUS_AVAIL_DESCR) {
			QPixmap * gg_st;

      if (userlist[j].status == GG_STATUS_AVAIL_DESCR)
        gg_st = new QPixmap((const char**)gg_actdescr_xpm);
      else
        gg_st = new QPixmap((const char**)gg_act_xpm);

			QPixmap * gg_st2;
			QString tmpstr, tmpstr2;
			tmpstr = mylist->item(i)->text();
			tmpstr2 = mylist->item(k)->text();
			fprintf(stderr, "KK Kadu::sortUsers(): k: %d, i: %d, j: %d\n", k, i, j);
			gg_st2 = new QPixmap(*mylist->item(k)->pixmap());
			mylist->changeItem(*gg_st, tmpstr, k);
			mylist->changeItem(*gg_st2, tmpstr2, i);
			delete gg_st;
			delete gg_st2;
			struct userlist tmpustr;
			tmpustr = userlist[k];
			userlist[k] = userlist[i];
			userlist[i] = tmpustr;
			k++;
			} else if (userlist[j].status	== GG_STATUS_BUSY || userlist[j].status	== GG_STATUS_BUSY_DESCR) {

			QPixmap * gg_st;

			if (userlist[j].status == GG_STATUS_BUSY_DESCR)
	 			gg_st = new QPixmap((const char**)gg_busydescr_xpm);
			else
  			gg_st = new QPixmap((const char**)gg_busy_xpm);

			QPixmap * gg_st2;
			QString tmpstr, tmpstr2;
			tmpstr = mylist->item(i)->text();
			tmpstr2 = mylist->item(k)->text();
			fprintf(stderr, "KK Kadu::sortUsers(): k: %d, i: %d, j: %d\n", k, i, j);
			gg_st2 = new QPixmap(*mylist->item(k)->pixmap());
			mylist->changeItem(*gg_st, tmpstr, k);
			mylist->changeItem(*gg_st2, tmpstr2, i);
			delete gg_st;
			delete gg_st2;
			struct userlist tmpustr;
			tmpustr = userlist[k];
			userlist[k] = userlist[i];
			userlist[i] = tmpustr;
			k++;
			} else if (userlist[j].status	== GG_STATUS_INVISIBLE2) {
			QPixmap * gg_st = new QPixmap((const char**)gg_invi_xpm);
			QPixmap * gg_st2;
			QString tmpstr, tmpstr2;
			tmpstr = mylist->item(i)->text();
			tmpstr2 = mylist->item(k)->text();
			fprintf(stderr, "KK Kadu::sortUsers(): k: %d, i: %d, j: %d\n", k, i, j);
			gg_st2 = new QPixmap(*mylist->item(k)->pixmap());
			mylist->changeItem(*gg_st, tmpstr, k);
			mylist->changeItem(*gg_st2, tmpstr2, i);
			delete gg_st;
			delete gg_st2;
			struct userlist tmpustr;
			tmpustr = userlist[k];
			userlist[k] = userlist[i];
			userlist[i] = tmpustr;
			k++;
			}

		mylist->setSelected(i, false);
		} //int i

		mylist->setSelected(item_selected, true);

}

/* cancel autoaway, we're alive */
void Kadu::enterEvent (QEvent * e) {
	autoaway->stop();
	autoaway->start(300000);
	if (autoawayed && socket_active && userlist_sent) {
		 fprintf(stderr, "KK Kadu::enterEvent(): auto away cancelled\n");
     i_am_busy = false;
		 autoawayed = false;
		 mycombo->setCurrentItem(0);
		 setOnline();
		}
	QWidget::enterEvent(e);
	}

/* invoked every config.autoawaytime of idleness seconds */
void Kadu::autoAway(void) {
	if (!config.autoaway) return;
	if (i_wanna_be_invisible || i_am_busy) return;
	if (!socket_active || !userlist_sent) return;
	fprintf(stderr, "KK Kadu::autoAway(): going auto away\n");
	setAway();
	i_am_busy = true;
	autoawayed = true;
	mycombo->setCurrentItem(1);
}

uin_t newUserToUin(const QString * str) {
  int i;
  for (i = 0; i < userlist.size(); i++)
    if (str->compare(__c2q(userlist[i].nickname)) == 0)
      break;

  if (i == userlist.size())
    return 0;
  else
    return userlist[i].uin;
  }
  
QString newUserToMobile(const QString * str) {
  int i;
  for (i = 0; i < userlist.size(); i++)
    if (str->compare(__c2q(userlist[i].nickname)) == 0)
      break;

  if (i == userlist.size())
    return "";
  else
    return userlist[i].mobile;
  }
  


/* menu and popup menu parser */
void Kadu::commandParser (int command) {
		int i = 0;
		char buf1[255];
switch (command) {
	case 1:
		new Message(mylist->currentText());
		break;
	case 2:
		new Chat(mylist->currentText(), 0, "chat window");
		break;
	case 3:
		removeUser(mylist->currentText().local8Bit(), false);
		break;
	case 4:
		//clear history
		confirmHistoryDeletion(mylist->currentText().local8Bit());
		break;
	case 5:
		new HistorybBox(newUserToUin(&mylist->currentText()));
		break;
	case 6:
		new UserInfo("user info", 0, newUserToUin(&mylist->currentText()));
		break;
	case 7:
		new SearchDialog;
		break;
	case 8:
		if (mute) mute = false;
		else mute = true;
		break;
	case 9:
		new Adduser(0, "add_user");
		break;
	case 10:
		new Ignored(0, "ignored");
		break;
	case 11:
		new About(0, "about");
		break;
	case 12:
		send_userlist();
		break;
	case 13:
		new Sms(0,mylist->currentText(),0);
		break;
	case 14:
		remindPassword();
		break;
	case 15:
		new Register;
		break;
	case 16:
		close_permitted = true;
		kadu->close(true);
		break;
	case 17:
		new SearchDialog(0,"User info",newUserToUin(&mylist->currentText()));
		break;
	case 18:
		new UserlistImport;
		break;
	case 19:
		new ConfigDialog;
		break;
	case 20:
		new UserlistExport;
	case 21:
		close_permitted = false;
		kadu->close(true);
	}
}

void confirmHistoryDeletion (const char * user) {
  char buf1[1023];
	
 switch( QMessageBox::information( kadu, "Kadu",i18n("Clear history?"),"No", "Yes", 0, 0, 1) ) {
 case 1: // Yes?
			snprintf(buf1, sizeof(buf1), "%s/.gg/history/%d",getenv("HOME"),UserToUin(user));
			fprintf(stderr, "KK History(): unlinking %s\n", buf1);
			unlink(buf1);
			break;
 case 0: // Nope?
			return;
	}
}

/* changes the active group */
void Kadu::changeGroup(int group) {
  activegrpno = group;
  grpmenu->setItemChecked(true, group-600);
  grpmenu->updateItem(group-600);
  grpmenu->repaint();
  std::cout << group-600 << std::endl;
  kadu->syncUserlist();
  kadu->sortUsers();
}

/* the list that pops up if we right-click one someone */
void Kadu::listPopupMenu (QListBoxItem * item) {
	if (item == NULL) return;

  QPopupMenu * pm;
	pm = new QPopupMenu(this);

	KIconLoader *loader = KGlobal::iconLoader();

	QPixmap msg;
	msg = loader->loadIcon("mail_generic", KIcon::Small);
	pm->insertItem(msg, i18n("Send message"), 1);
  pm->insertItem(i18n("Open chat window"), 2);
	pm->insertItem(i18n("Send SMS"), 13);

	pm->insertSeparator();
	
	int i = 0;
	while (item->text().compare(__c2q(userlist[i].nickname)) != 0) i++;
	pm->insertItem(i18n("Remove from userlist"), 3);
	pm->insertItem(i18n("Clear history"), 4);
	QPixmap history;
	history = loader->loadIcon("history", KIcon::Small);
	pm->insertItem(history, i18n("View history"), 5);
	pm->insertItem(loader->loadIcon("identity", KIcon::Small), i18n("View/edit user info"), 6);
	pm->insertItem(i18n("Lookup in directory"), 17);
	pm->insertSeparator();
	if (mute) {
		QPixmap snd_unmute((const char **)snd_mute_xpm);
		QIconSet icon(snd_unmute);
		pm->insertItem(icon, i18n("Unmute sounds"), 8);
		}
	else {
		QPixmap snd_mute((const char **)snd_unmute_xpm);
		QIconSet icon(snd_mute);
		pm->insertItem(icon, i18n("Mute sounds"), 8);		
		}
	pm->insertSeparator();
	pm->insertItem(i18n("About..."), 11);

	connect(pm, SIGNAL( activated(int) ), this, SLOT( commandParser(int) ));	
	pm->exec(QCursor::pos());
	
	}

/* if something's pending, open it, if not, open new message */
void Kadu::sendMessage (QListBoxItem * item) {

	for (int i = pending.size() - 1; i >= 0; i--) {

		if (pending[i].uin == (unsigned int) UserToUin(item->text().local8Bit())) {
			new rMessage(item->text(), i);
			return;
			}
		}
			new Message (item->text());
			return;
}

/* is it a chat or is it not? */
void rMessage::replyMessage (void) {
		if (tchat)
			new Message (tmprcvr, true);
		else
			new Message (tmprcvr);
		this->close(true);
}

/* a message! someone loves us! */
rMessage::rMessage (const QString & nick, int i, QDialog* parent , const char *name) : QDialog (parent, name) {
 bool sysmsg = false;
 int j;

/*ool isdig = false;
	for (int k = 0; k < nick.local8Bit().length(); k++) {
		if (isdigit(nick.local8Bit()[k]) != 0) {
			isdig = true;
			break;
		}
	}*/

	sender = nick;
	if (sender.compare("System")==0) sysmsg = true;
	
	this->setWFlags(Qt::WDestructiveClose);

	this->resize(345,220);
	this->setCaption("Message from " + sender);

	lejbel = new QLabel(this);
	lejbel->setText(i18n("Sender: "));
	lejbel->setGeometry(5,5,200,10);

	QLineEdit * sendere = new QLineEdit(this);
	sendere->setText(sender);
	sendere->setReadOnly(true);

	QLabel * klejbel = new QLabel(this);
	klejbel->setText(i18n("Class: "));

	QLineEdit * msgclasse = new QLineEdit(this);
		if (pending[i].msgclass == GG_CLASS_MSG) {
			msgclasse->setText("Message");
			tchat = false;
	}	else if (pending[i].msgclass == GG_CLASS_CHAT) {
			msgclasse->setText("Chat");
			tchat = true;
			} else if (pending[i].uin == config.uin)
			msgclasse->setText("System");
		else if (pending[i].msgclass == GG_CLASS_OFFLINE)
			msgclasse->setText("Queued");
		else
			msgclasse->setText("Unknown");		
	msgclasse->setReadOnly(true);

	bool __chat = false;
	QPushButton * chatbtn;
	if (pending[i].msgclass == GG_CLASS_CHAT) {
	chatbtn = new QPushButton (this);
	chatbtn->setText(i18n("C&hat"));
	connect(chatbtn, SIGNAL( clicked() ), this, SLOT( openChat() ));
	 __chat = true;
		}

	body = new QMultiLineEdit(this);
	body->setGeometry(5,20,305,170);
	body->setText(__c2q(*pending[i].msg));
	body->setReadOnly(true);
	body->setWordWrap(QMultiLineEdit::WidgetWidth);

  fprintf(stderr,"KK rMessage::rMessage(): message in slot %d\n", i);

	if (i != pending.size() - 1) {
		for (j = i; j < pending.size() -1; j++) {
			pending[j].uin = pending[j+1].uin;
			pending[j].msg = pending[j+1].msg;
			}
		pending.resize(pending.size()-1);

		} else {
	pending[i].uin = 0;
	delete pending[i].msg;
	}

	QPushButton * btn;
	btn = new QPushButton (this);
	btn->setGeometry(220,195,80,20);
	btn->setText(i18n("&Reply"));
	btn->setIconSet(QIconSet( QPixmap((const char**)reply_ico) ));
	connect(btn, SIGNAL( clicked() ), this, SLOT ( replyMessage() ));

	if (sysmsg)
		btn->setEnabled(false);
	else
		strncpy(tmprcvr, sender, 255);

	QPushButton * closebtn;
	closebtn = new QPushButton(this);
	closebtn->setText(i18n("&Close"));
	KIconLoader *loader = KGlobal::iconLoader();
	closebtn->setIconSet(QIconSet( loader->loadIcon("stop", KIcon::Small) ));
	connect(closebtn, SIGNAL( clicked() ), this, SLOT( cleanUp() ));

	bool others_pending = FALSE;
	if (!sysmsg) {
	for (i = 0; i < pending.size(); i++) {
		if (pending[i].uin == (unsigned int) UserToUin(nick.local8Bit()))
			others_pending = TRUE;
			break;
		}
	}

	if (!others_pending && !sysmsg) {
		int index = 0;
		while (userlist[index].uin != (unsigned int) UserToUin(nick.local8Bit()))
			index++;		

	if (userlist[index].status == GG_STATUS_AVAIL) {
		mylist->changeItem(QPixmap((const char **)gg_act_xpm), nick, index);
	} else if (userlist[index].status == GG_STATUS_AVAIL_DESCR) {
		mylist->changeItem(QPixmap((const char **)gg_actdescr_xpm), nick, index);
	}	else if (userlist[index].status == GG_STATUS_BUSY) {
		mylist->changeItem(QPixmap((const char **)gg_busy_xpm), nick, index);
	}	else if (userlist[index].status == GG_STATUS_BUSY_DESCR) {
		mylist->changeItem(QPixmap((const char **)gg_busy_xpm), nick, index);
	} else if (userlist[index].status == GG_STATUS_NOT_AVAIL) {
		mylist->changeItem(QPixmap((const char **)gg_inact_xpm), nick, index);
	} else if (userlist[index].status == GG_STATUS_NOT_AVAIL_DESCR) {
		mylist->changeItem(QPixmap((const char **)gg_inact_xpm), nick, index);
	} else if (userlist[index].status == GG_STATUS_INVISIBLE2) {
		mylist->changeItem(QPixmap((const char **)gg_invi_xpm), nick, index);
	} else if (userlist[index].status == GG_STATUS_INVISIBLE_DESCR) {
		mylist->changeItem(QPixmap((const char **)gg_invidescr_xpm), nick, index);
	} else {
		mylist->changeItem(QPixmap((const char **)gg_act_xpm), nick, index);
	}		
		mylist->repaint();
		
	}

	others_pending = FALSE;
	for (i = 0; i < pending.size(); i++) {
		if (pending[i].uin != 0) {
			others_pending = TRUE;
			break;
		}
	}

	if (!others_pending && !i_wanna_be_invisible && own_description.length() < 1 && !i_am_busy)
		dw->setActive();
	else if (!others_pending && i_am_busy && own_description.length() < 1)
		dw->setBusy();
	else if (!others_pending && i_am_busy && own_description.length() > 0)
		dw->setBusyDescr();
	else if (!others_pending && i_wanna_be_invisible)
		dw->setInvisible();

	QGridLayout * grid = new QGridLayout(this,3,5,3,3);
	grid->addWidget(lejbel,0,0);
	grid->addMultiCellWidget(sendere,0,0,1,2);
	grid->addWidget(klejbel,0,3,Qt::AlignRight);
	grid->addWidget(msgclasse,0,4);
	grid->addMultiCellWidget(body,1,1,0,4);
	grid->addWidget(btn,2,4);
 	grid->addWidget(closebtn,2,3);
  if (__chat) { grid->addWidget(chatbtn,2,2); }

	this->show();
}

/* clean up the mess */
void rMessage::cleanUp(void) {
	/* should we add some more? */
		this->close(true);
}

/* let's chat some more */
void rMessage::openChat(void) {
new Chat(tmprcvr, 0, "chat window");
this->close(true);
}

/* send a message, send me a message */
Message::Message (const QString & nick, bool tchat, QDialog* parent , const char *name) : QDialog (parent, name) {
  QAccel *acc = new QAccel( this );
  acc->connectItem( acc->insertItem(Key_Return+CTRL), this, SLOT(commitSend()) );

  nicksnd = nick;
	QPushButton * closebtn;
	QLabel * statuslab;
	QLineEdit * nickedit;
	QLineEdit * statusedit;

	int i = 0;

	while (acks[i].seq != 0)
		i++;

	index = i;
	
	this->resize(355,235);
	this->setCaption("Message for " + nicksnd);

	nicknamelab = new QLabel(this);
	nicknamelab->setText("Recipient");
	nicknamelab->setGeometry(5,5,65,20);

	nickedit = new QLineEdit(this);
	nickedit->setGeometry(70, 5, 80, 20);
	nickedit->setText(nicksnd);
	nickedit->setReadOnly(TRUE);

	statuslab = new QLabel(this);
	statuslab->setText("Status");
	statuslab->setGeometry(180, 5, 55, 20);

	statusedit = new QLineEdit(this);
	statusedit->setGeometry(230, 5, 60, 20);
	
	int status = GetStatusFromUserlist( UserToUin(nicksnd) );
	switch (status) {
		case GG_STATUS_AVAIL:
			statusedit->setText("Online");
			break;
		case GG_STATUS_AVAIL_DESCR:
			statusedit->setText("Online");
			break;
		case GG_STATUS_BUSY:
			statusedit->setText("Away");
			break;
		case GG_STATUS_BUSY_DESCR:
			statusedit->setText("Busy");
			break;
		case GG_STATUS_NOT_AVAIL:
			statusedit->setText("Offline");
			break;
		case GG_STATUS_NOT_AVAIL_DESCR:
			statusedit->setText("Offline");
			break;
		case GG_STATUS_INVISIBLE2:
			statusedit->setText("Invisible");
			break;
		case GG_STATUS_INVISIBLE_DESCR:
			statusedit->setText("Invisible");
			break;
		case -1:
			statusedit->setText("(Unknown)");
			break;
	}
	statusedit->setReadOnly(TRUE);

	body = new QMultiLineEdit(this);
	body->setGeometry(5,30,295,150);
	body->setWordWrap(QMultiLineEdit::WidgetWidth);

	KIconLoader *loader = KGlobal::iconLoader();

	sendbtn = new QPushButton (this);
	sendbtn->setGeometry(240,185,60,20);
	sendbtn->setText(i18n("&Send"));
	sendbtn->setIconSet(QIconSet( loader->loadIcon("forward", KIcon::Small) ));
	connect(sendbtn, SIGNAL( clicked() ), this, SLOT( commitSend() ));
	QToolTip::add(sendbtn, "Sends message. Hit CTRL+Enter or ALT+S for shortcut");

	closebtn = new QPushButton (this);
	closebtn->setGeometry(170, 185, 60, 20);
	closebtn->setText(i18n("&Close"));
	closebtn->setIconSet(QIconSet( loader->loadIcon("stop", KIcon::Small) ));
	connect(closebtn, SIGNAL( clicked() ), this, SLOT( reject() ));
	QHButtonGroup * btngrp = new QHButtonGroup(this);

	b_chat = new QRadioButton(btngrp);
	b_chat->setText(i18n("C&hat"));
	QToolTip::add(b_chat, i18n("This option sends the message as a chat event"));

	QRadioButton * b_msg = new QRadioButton(btngrp);
	b_msg->setText(i18n("&Mesg"));
	if (!tchat)
		b_msg->setChecked(true);
	else
		b_chat->setChecked(true);
	QToolTip::add(b_msg, i18n("This option sends the message ordinarily"));

	btngrp->insert(b_chat, 1);
	btngrp->insert(b_msg, 2);

	QPushButton * history = new QPushButton(this);
	history->setPixmap( QPixmap((const char**)history_xpm) );
	QToolTip::add(history, i18n("Show history"));
	
	connect(history, SIGNAL( clicked() ), this, SLOT ( HistoryBox() ));

	QGridLayout * grid = new QGridLayout (this, 4, 5, 5, 5);
	grid->addWidget(nicknamelab, 0, 0);
	grid->addWidget(nickedit, 0, 1);
	grid->addWidget(history, 0, 2);
	grid->addWidget(statuslab, 0, 3, Qt::AlignRight);
	grid->addWidget(statusedit, 0, 4);
	grid->addMultiCellWidget(body, 2, 2, 0, 4);
	grid->addMultiCellWidget(btngrp, 3,3, 0,2);
	grid->addWidget(closebtn, 3, 3);
	grid->addWidget(sendbtn, 3, 4);

	grid->addRowSpacing(1, 5);
	grid->addRowSpacing(2, 20);

	this->show();
}

/* the actual send */
void Message::commitSend(void) {
	sendbtn->setDisabled(true);

	int uin;
	QString text;
	text = body->text();
	if ((text.compare("") == 0) || (text.compare(" ") == 0)) {
		return;
		}
  QCString tmp(text.local8Bit());
	unsigned char * utmp = (unsigned char *) tmp.data();	

  body->setReadOnly(true);
	uin = UserToUin(nicksnd);

	int seq;
	if (config.logmessages)
		appendHistory(uin,utmp,TRUE);
	iso_to_cp(utmp);
	if (b_chat->isChecked() == true) {
	seq = gg_send_message(&sess, GG_CLASS_CHAT, uin, utmp);
	printf("seq: %d\n", seq); }
	else {
	seq =	gg_send_message(&sess, GG_CLASS_MSG, uin, utmp);
	}

	acks[index].seq = seq;
	acks[index].ptr = this;

	printf("KK Message::commitSend(): Message to uin %i queued for delivery\n", uin);
	this->setCaption("Message for " + nicksnd + " [sending...]");
	body->setReadOnly(false);	
}

/* KGB informs: the message was delivered. let's close the window */
/* this function is called back from the network events handler */
void Message::gotAck(void) { this->close(true); }

/* for the sake of garbage collecting */
void Message::closeEvent(QCloseEvent * e)
{ acks[index].seq = 0; acks[index].ptr = NULL; QWidget::closeEvent(e); }

/* for sanity's sake */
void Message::accept() { this->close(true); }
void Message::reject() { this->close(true); }

/* sends the userlist. ripped off EKG, actually, but works */
void send_userlist() {
	uin_t *uins;
	int i;

	uins = (uin_t *) malloc(userlist.size() * sizeof(uin_t));
	
	for (i = 0; i < userlist.size(); i++)
		uins[i] = userlist[i].uin;

  /* we were popping up sometimes, so let's keep the server informed */
	if (i_wanna_be_invisible)
		gg_change_status(&sess, GG_STATUS_INVISIBLE);

	gg_notify(&sess, uins, userlist_count);
	printf("KK send_userlist(): Userlist sent\n");

	free(uins);
}


/* when we want to change the status */
void Kadu::slotHandleState (const QString & str) {
	if (str == "Online")
		setOnline();
	else if (str == "Offline")
		disconnectNetwork();
	else if (str == "Away")
		setAway(false);
	else if (str == "Invisible")
		setInvisible();
	else if (str == "Away  ") {
		new ChooseDescription;
		setAway(true);
		}
		
}

/* takes a string, and generates a random number basing in it :) */
int UserToUin (const char * user) {
	for (int i = 0; i < userlist.size(); i++) {
		if (QString::compare(__c2q(userlist[i].nickname),user) == 0)
			return userlist[i].uin;
		}
	
	return 0;
}

/* takes the UIN number, returns a random string ;) */
char * UinToUser (uin_t uin) {
	if (uin == config.uin)
		return "System";

		int i;
		for (i = 0; i < userlist.size(); i++) {
       if (userlist[i].uin == uin) {
				return userlist[i].nickname;
  			}
			}

	/* the guy was not on our list. let's add him */

  if (userlist[userlist.size()-1].uin == 0)
    userlist.resize(userlist.size()+1);
  else
    userlist.resize(userlist.size()+2);

    userlist[userlist.size()-1].uin = 0;
    i = userlist.size()-2;

	userlist[i].uin = uin;
	char _nick[512];
	snprintf(_nick, sizeof(_nick), "(%d)", uin);
	userlist[i].nickname = strdup(_nick);
	userlist[i].first_name = strdup(_nick);
	userlist[i].last_name = strdup(_nick);
  userlist[i].comment = strdup(_nick);
  userlist[i].mobile = NULL;
  userlist[i].group = NULL;
  userlist[i].description = NULL;
	userlist[i].status = GG_STATUS_NOT_AVAIL;
	userlist[i].anonymous = true;

  kadu->syncUserlist();
	gg_notify(&sess, &uin, 1);
	return userlist[i].nickname;

	}

/* most of the functionality is doubled in setInvisible because
   I am too lame to write a common function. */
void Kadu::setOnline() {
    if (!userlist_sent) {
    doBlink = true;
    mycombo->setCurrentItem(0);
    QTimer::singleShot(1000, this, SLOT( blink() ));
    }

		i_am_busy = false;
	  /* there are three times more booleans than we need. sorry. */
		i_wanna_be_invisible = false;
		disconnect_planned = false;		
		if (socket_active) {
      doBlink = false;
			gg_change_status(&sess, GG_STATUS_AVAIL | GG_STATUS_FRIENDS_MASK);
			statuslabel->setPixmap(QPixmap((const char**)gg_act_xpm) );
      kadu->setIcon(QPixmap((const char**)gg_act_xpm) );

			
		bool others_pending = FALSE;
			for (int i = 0; i < pending.size(); i++) {
					if (pending[i].uin != 0) others_pending = TRUE;
				break;
				}
		if (!others_pending && socket_active)	
			dw->setActive();
			
			return;
			} else {
    }

//		kadu->setIcon( QPixmap((const char**)gg_act_xpm) );			
    if (!autohammer) {
  		if (progresswindow != NULL)
        progresswindow->close(true);
      progresswindow = new Operation( "Connecting to network", "Cancel", 7 ); // <-- this is the progress bar, in case the name misleads you ;)
      }

    socket_active = TRUE;
		last_ping = time(NULL);
    loginparams.status = GG_STATUS_AVAIL | GG_STATUS_FRIENDS_MASK;
    loginparams.password = config.password;
    loginparams.uin = config.uin;
  	sess = * gg_login(&loginparams);

		QObject::connect(pingtimer, SIGNAL(timeout()), kadu, SLOT(pingNetwork()));
		pingtimer->start(60000);

		QObject::connect(connectimer, SIGNAL(timeout()), kadu, SLOT(nConnect()));		
		connectimer->start(50, true);

		QObject::connect(readevent, SIGNAL(timeout()), kadu, SLOT(checkConnection()));
		readevent->start(10000);

}

void Kadu::checkConnection(void) {
	// Since it doesn't work anymore...
	return;	

/*	if ((last_read_event < time(NULL) - 90) && timeout_connected && socket_active) {
		timeout_connected = false;
		int i = 0;
		QPixmap qp_inact((const char **)gg_inact_xpm);
		while (userlist[i].uin != 0) {
			mylist->changeItem(qp_inact, userlist[i].nickname, i);
			i++;
			}
		char error[1023];
		QMessageBox * msgb;

		snprintf(error, sizeof(error), "nConnect(): Timeout after 90 seconds.\nDisconnecting.\n");
		fprintf(stderr, error);
		disconnectNetwork();			
		socket_active = false;
		mycombo->setCurrentItem(3);
		last_read_event = time(NULL);
		msgb = new QMessageBox(this);
		msgb->warning(kadu, "Connect error", error );
	} */
}

/* watches DCC, called from nConnect IIRC */
void Kadu::watchDcc(void) {
		FD_ZERO(&dcc_rd);
		FD_ZERO(&dcc_wd);

		if ((dccsock->check & GG_CHECK_READ))
			FD_SET(dccsock->fd, &dcc_rd);
		if ((dccsock->check & GG_CHECK_WRITE))
			FD_SET(dccsock->fd, &dcc_wd);

		dcc_tv.tv_sec = 0;
		dcc_tv.tv_usec = 500;

		dcc_ret = select(dccsock->fd + 1, &dcc_rd, &dcc_wd, NULL, &dcc_tv);

		if (dcc_ret < 1) {
			return;
		} else { // begin main block
			fprintf(stderr, "KK Kadu::watchDcc(): data on socket\n");			
				if (!(dcc_e = gg_dcc_watch_fd(dccsock))) {
					socket_active = false;
					printf("KK Connection broken unexpectedly!\n");
					pingtimer->stop();
					autoaway->stop();
					socket_active = false;
					config.allowdcc = false;
					return;
					}

		switch (dcc_e->type) {
			case GG_EVENT_NONE:
				break;
			case GG_EVENT_DCC_ERROR:
				printf("KK GG_EVENT_DCC_ERROR\n");
				break;
			case GG_EVENT_DCC_NEW:
				new DccGet(dcc_e->event.dcc_new);
				printf("KK GG_EVENT_DCC_NEW: spawning object\n");
				break;
			default:
				break;
			}

		gg_free_event(dcc_e);
		} // end main block
}

/* the main network function called every n msec from QTimer */
void Kadu::nConnect(void) {
		if (config.allowdcc)
			watchDcc();

		FD_ZERO(&rd);
		FD_ZERO(&wd);
		bool dis2 = false;

		if ((sess.check & GG_CHECK_READ))
			FD_SET(sess.fd, &rd);
		if ((sess.check & GG_CHECK_WRITE))
			FD_SET(sess.fd, &wd);

		tv.tv_sec = 0;
		tv.tv_usec = 0;

		ret = select(sess.fd + 1, &rd, &wd, NULL, &tv);

		if (ret < 1) {
      connectimer->start(50, TRUE);	
			return;
		} else {

  		if ((FD_ISSET(sess.fd, &rd) || FD_ISSET(sess.fd, &wd))) {
				if (!(e = gg_watch_fd(&sess))) {
					printf("KK Connection broken unexpectedly!\n");
			char error[512];
      disconnectNetwork();
			snprintf(error, sizeof(error), "eventHandler(): Unscheduled connection termination\n");
			fprintf(stderr, error);
			mycombo->setCurrentItem(3);
			QMessageBox::warning(kadu, "Connect error", error );
    	gg_free_event(e);
			return;	
			}

		switch (sess.state) {
			case GG_STATE_RESOLVING:
				fprintf(stderr, "KK Kadu::nConnect(): Resolving address\n");
				break;
			case GG_STATE_CONNECTING:
				fprintf(stderr, "KK Kadu::nConnect(): Connecting to hub\n");
				break;
			case GG_STATE_READING_DATA:
				fprintf(stderr, "KK Kadu::nConnect(): Fetching data from hub\n");
				break;
			case GG_STATE_CONNECTING_GG:
				fprintf(stderr, "KK Kadu::nConnect(): Connecting to server\n");
				break;
			case GG_STATE_READING_KEY:
				fprintf(stderr, "KK Kadu::nConnect(): Waiting for hash key\n");
				break;
			case GG_STATE_READING_REPLY:
				fprintf(stderr, "KK Kadu::nConnect(): Sending key\n");
				break;
			case GG_STATE_CONNECTED:
				break;
			default:
				break;
			}

				if (sess.check == GG_CHECK_READ) {
				 timeout_connected = true;
		     last_read_event = time(NULL);
			}
		if (e->type == GG_EVENT_MSG) {
			eventRecvMsg(e->event.msg.msgclass, e->event.msg.sender, e->event.msg.message, e->event.msg.time, 0, NULL);
		}

		if (e->type == GG_EVENT_NOTIFY_DESCR) {
			eventGotUserlistWithDescription(e);
      this->sortUsers();
			}

		if (e->type == GG_EVENT_NOTIFY) {
			eventGotUserlist(e);
      this->sortUsers();
			}

		if (e->type == GG_EVENT_STATUS) {
			eventStatusChange(e);
			this->syncUserlist();
      this->sortUsers();
			}

		if (e->type == GG_EVENT_ACK) {
			fprintf(stderr, "KK nConnect(): message reached %d (seq %d)\n", e->event.ack.recipient, e->event.ack.seq);
			ackHandler(e->event.ack.seq);
		}

				if (e->type == GG_EVENT_CONN_SUCCESS) {
          doBlink = false;
					send_userlist();
          autohammer = false;

        switch (loginparams.status&(~GG_STATUS_FRIENDS_MASK)) {
          case GG_STATUS_AVAIL:
      			statuslabel->setPixmap(QPixmap((const char**)gg_act_xpm) );
          	kadu->setIcon( QPixmap((const char**)gg_act_xpm) );			
            dw->setActive();
            break;
          case GG_STATUS_INVISIBLE:
      			statuslabel->setPixmap(QPixmap((const char**)gg_invi_xpm) );
          	kadu->setIcon( QPixmap((const char**)gg_invi_xpm) );			
            dw->setInvisible();
            break;
          case GG_STATUS_BUSY:
      			statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
          	kadu->setIcon( QPixmap((const char**)gg_busy_xpm) );			
            dw->setBusy();
            break;
          case GG_STATUS_BUSY_DESCR:
      			statuslabel->setPixmap(QPixmap((const char**)gg_busydescr_xpm) );
          	kadu->setIcon( QPixmap((const char**)gg_busydescr_xpm) );			
            dw->setBusyDescr();
            break;
          }

          userlist_sent = true;
					gg_free_event(e);
          connectimer->start(50, true);
    			return;
				}
				if (e->type == GG_EVENT_CONN_FAILED) {
					char error[512];
					snprintf(error, sizeof(error), "Unable to connect, the following error has occured:\n%s\nKeep trying to connect?", strerror(errno));
					disconnectNetwork();	
					mycombo->setCurrentItem(3);
					printf("KK Connection failed\n");
					gg_free_event(e);
					fprintf(stderr, error);
			
					if (autohammer) {
						if (i_wanna_be_invisible)
							QTimer::singleShot(1000, this, SLOT(setInvisible()));
						else
							QTimer::singleShot(1000,this, SLOT(setOnline()));
						return;
					}

				 switch( QMessageBox::information( kadu, "Connect error",error,"No", "Yes", 0, 0, 1) ) {
					 case 1: // Yes?
						autohammer = true;
						if (i_wanna_be_invisible) QTimer::singleShot(100, this, SLOT(setInvisible()));
						else QTimer::singleShot(100,this, SLOT(setOnline()));
						break;
					 case 0: // Nope?
						break;
					}

          connectimer->start(50, true);
					return;
				}

	if (sess.state == GG_STATE_IDLE && socket_active && userlist_sent) {
  	char error[512];
		socket_active = false;
		int i = 0;
		QPixmap qp_inact((const char **)gg_inact_xpm);
		while (userlist[i].uin != 0) {
			mylist->changeItem(qp_inact, userlist[i].nickname, i);
			i++;
			}
		snprintf(error, sizeof(error), "eventHandler(): Unscheduled connection termination\n");
		fprintf(stderr, error);
		disconnectNetwork();			
		mycombo->setCurrentItem(3);
		QMessageBox::warning(kadu, "Connect error", error );

	}
			gg_free_event(e);
			}
		}

  connectimer->start(50, true);
	return;

}
void Kadu::pingNetwork(void) {
	gg_ping(&sess);
	// Fuck you, since you don't reply anyway

		if (socket_active && i_wanna_be_invisible)
  	  gg_change_status(&sess, GG_STATUS_INVISIBLE | GG_STATUS_FRIENDS_MASK);

	}

void Kadu::setAway(bool with_description) {
	i_am_busy = true;
	i_wanna_be_invisible = false;
	disconnect_planned = false;		

  if (!userlist_sent) {
    doBlink = true;
    mycombo->setCurrentItem(1);
    QTimer::singleShot(1000, this, SLOT( blink() ));
    }

  if (!socket_active) {
    if (!autohammer) {
  		if (progresswindow != NULL)
        progresswindow->close(true);
      progresswindow = new Operation( "Connecting to network", "Cancel", 7 ); // <-- this is the progress bar, in case the name misleads you ;)
    }

    socket_active = TRUE;
		last_ping = time(NULL);
    loginparams.status = GG_STATUS_BUSY | GG_STATUS_FRIENDS_MASK;
    loginparams.uin = config.uin;
    loginparams.password = config.password;
  	sess = * gg_login(&loginparams);

		QObject::connect(pingtimer, SIGNAL(timeout()), kadu, SLOT(pingNetwork()));
		pingtimer->start(60000);

		QObject::connect(connectimer, SIGNAL(timeout()), kadu, SLOT(nConnect()));		
		connectimer->start(50, true);

		QObject::connect(readevent, SIGNAL(timeout()), kadu, SLOT(checkConnection()));
		readevent->start(10000);

    return;
  }

	if (with_description)
		gg_change_status_descr(&sess, GG_STATUS_BUSY_DESCR, own_description.local8Bit());
	else
		gg_change_status(&sess, GG_STATUS_BUSY | GG_STATUS_FRIENDS_MASK);

		bool others_pending = FALSE;
			for (int i = 0; i < pending.size(); i++) {
					if (pending[i].uin != 0) {
            others_pending = TRUE;
    				break;
            }
				}

    if (socket_active) {
			if (with_description)	{		
        if (!others_pending)
  				dw->setBusyDescr();
				statuslabel->setPixmap(QPixmap((const char**)gg_busydescr_xpm) );
				kadu->setIcon( QPixmap((const char**)gg_busydescr_xpm) );			
			} else {
        if (!others_pending)
  				dw->setBusy();
				statuslabel->setPixmap(QPixmap((const char**)gg_busy_xpm) );
				kadu->setIcon( QPixmap((const char**)gg_busy_xpm) );			
			}

    }

}

void Kadu::setInvisible() {
  if (!userlist_sent) {
    doBlink = true;
    mycombo->setCurrentItem(2);
    QTimer::singleShot(1000, this, SLOT( blink() ));
    }
	i_am_busy = false;
	i_wanna_be_invisible = true;
	disconnect_planned = false;		
//	statuslabel->setPixmap(QPixmap((const char**)gg_invi_xpm) );
//	dw->setInvisible();
//	kadu->setIcon( QPixmap((const char**)gg_invi_xpm) );			

		if (socket_active) {
			gg_change_status(&sess, GG_STATUS_INVISIBLE | GG_STATUS_FRIENDS_MASK);
			statuslabel->setPixmap(QPixmap((const char**)gg_invi_xpm) );
      kadu->setIcon( QPixmap((const char**)gg_invi_xpm) );			


		bool others_pending = FALSE;
			for (int i = 0; i < pending.size(); i++) {
					if (pending[i].uin != 0) others_pending = TRUE;
				break;
				}
		if (!others_pending)	
			dw->setInvisible();

			return;
			}

    if (!autohammer) {
  		if (progresswindow != NULL)
        progresswindow->close(true);
      progresswindow = new Operation( "Connecting to network", "Cancel", 7 ); // <-- this is the progress bar, in case the name misleads you ;)
      }

    socket_active = TRUE;
		last_ping = time(NULL);
    loginparams.status = GG_STATUS_INVISIBLE | GG_STATUS_FRIENDS_MASK;
    loginparams.uin = config.uin;
    loginparams.password = config.password;
  	sess = * gg_login(&loginparams);

		QObject::connect(pingtimer, SIGNAL(timeout()), kadu, SLOT(pingNetwork()));
		pingtimer->start(60000);

		QObject::connect(connectimer, SIGNAL(timeout()), kadu, SLOT(nConnect()));		
		connectimer->start(50, true);

		QObject::connect(readevent, SIGNAL(timeout()), kadu, SLOT(checkConnection()));
		readevent->start(10000);
}

void Kadu::disconnectNetwork() {
  doBlink = false;
	fprintf(stderr, "KK disconnectNetwork(): calling offline routines\n");
	connectimer->stop();
	pingtimer->stop();
	readevent->stop();
  autohammer = false;

  if (progresswindow != NULL) {
/*  this causes SEGVs. why? */
//    progresswindow->close(true);
    progresswindow = NULL;
    }

	i_am_busy = FALSE;
	disconnect_planned = TRUE;
	gg_logoff(&sess);
	userlist_sent = FALSE;

  for (int i = 0; i < userlist.size(), userlist[i].uin != 0; i++) {
    UinToUserlistEntry(userlist[i].uin, GG_STATUS_NOT_AVAIL);
    }

  syncUserlist();
  sortUsers();

	socket_active = FALSE;
	statuslabel->setPixmap(QPixmap((const char**)gg_inact_xpm) );
	dw->setInactive();
	kadu->setIcon(QPixmap((const char**)gg_inact_xpm) );


}

/* reading only ignore file right now */
void readConfig(void)
{
	FILE *f;
	char buf[256];

	char * path = getenv("HOME");
	char * path3 = "/.gg/ignore";
	char buffer[255], buffer2[256];
	snprintf(buffer2,256,"%s%s",path,path3);	

	ignore: if (!(f = fopen(buffer2, "r"))) {
		fprintf(stderr, "readConfig(): Failed to open ignore file. Ignore list empty. Need to read manual?\n");
		return; }

	while (fgets(buf, sizeof(buf) -1, f)) {
		if (buf[strlen(buf) - 1] == '\n')
			buf[strlen(buf) - 1] = 0;

		if (buf[0] == '#')
			continue;

		addIgnored(atoi(buf));
   }
		
	return;
}

DockWidget::DockWidget(QWidget *parent, const char *name ) : KSystemTray( parent, name )
{
if (!config.dock) {
return;
}

this->setPixmap( QPixmap((const char**)gg_inact_xpm) );
QToolTip::add(this, "Left click - hide/show window\nMiddle click - next message");
this->show(); }

void DockWidget::setActive(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_act_xpm) ); }

void DockWidget::setInactive(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_inact_xpm) ); }

void DockWidget::setBusy(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_busy_xpm) ); }

void DockWidget::setBusyDescr(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_busydescr_xpm) ); }

void DockWidget::setInvisible(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_invi_xpm) ); }

void DockWidget::setMsg(void) { if (!config.dock) return;
this->setPixmap( QPixmap((const char**)gg_msg_xpm) ); }

void DockWidget::mousePressEvent(QMouseEvent * e) {
if (!config.dock) return;
	bool message = false;
	int i;
	for (i = pending.size() - 1; i >= 0; i--) {
		if (pending[i].uin != 0) {
			message = true;
			break;
			}
		}

	if (e->button() == MidButton && message) {
		new rMessage(UinToUser(pending[i].uin), i);
		return;
		}

	KSystemTray::mousePressEvent(e);
}

void Message::HistoryBox (void) {
	new HistorybBox(UserToUin(nicksnd));
	}

HistorybBox::HistorybBox (uin_t uin) {
	this->setCaption(i18n("History"));
	this->setWFlags(Qt::WDestructiveClose);

	QGridLayout * grid = new QGridLayout(this, 2,1,3,3);

	body = new QMultiLineEdit(this, "History browser");
	body->setReadOnly(true);
	body->setWordWrap(QMultiLineEdit::WidgetWidth);
	body->setWrapPolicy(QMultiLineEdit::Anywhere);
	QPushButton * closebtn = new QPushButton(this);
	closebtn->setText(i18n("&Close"));


	char * path = getenv("HOME");
	char * path2 = "/.gg/history/";
	char path3[255];
	snprintf(path3,255,"%s%d",path2,uin);
	char buffer[511];
	snprintf(buffer,511,"%s%s",path,path3);

	QFile f(buffer);
	if (f.open(IO_ReadOnly)) {
		char *cbody = (char *) malloc(f.size()+1);
		f.readBlock(cbody, f.size());
		cbody[f.size()] = 0;
		body->setText(__c2q(cbody));
	} else {
		fprintf(stderr, "HistoryBox(): Error opening history file %s\n", buffer);
	 	body->setText(i18n("Error opening history file"));
	}

	grid->addWidget(body,0,0);
	grid->addWidget(closebtn,1,0, Qt::AlignRight);

	connect(closebtn, SIGNAL( clicked() ), this, SLOT( close() ));

	this->resize(500,400);
	this->show();
}

void Kadu::cleanUp(void) {
	//	may be of use
	if (sess.password !=NULL) free(sess.password);
	writeIgnored(NULL);
	}

Kadu::~Kadu(void) { ; }

void remindPassword() {
				struct gg_http *h = gg_remind_passwd(config.uin, 0);
        struct gg_pubdir *dupa;
			  dupa = (gg_pubdir *) h->data;

				if (h && dupa->success)
					printf("zrobione!\n");
				else
					printf("serwer nie chce.\n");

				gg_free_remind_passwd(h);

	}

void Kadu::createMenu() {

KIconLoader *loader = KGlobal::iconLoader();

QPopupMenu * ppm = new QPopupMenu(this);
ppm->insertItem(i18n("Manage &ignored"), 10);
ppm->insertItem(loader->loadIcon("configure", KIcon::Small), i18n("&Configuration"), 19);
ppm->insertItem(loader->loadIcon("reload", KIcon::Small), i18n("Resend &userlist"), 12);
ppm->insertSeparator();

grpmenu = new QPopupMenu(this);
grpmenu->insertItem(i18n("All"), 600);
grpmenu->insertSeparator();

/*
for (int k = 0; k < grouplist.size(); k++) {
    grpmenu->insertItem(__c2q(grouplist[k].name), grouplist[k].number);
    }

ppm->insertItem(i18n("Groups"), grpmenu);

QObject::connect(grpmenu, SIGNAL( activated(int) ), this, SLOT( changeGroup(int) ));

ppm->insertSeparator();
*/

ppm->insertItem(i18n("Remind &password"), 14);
QPixmap new__user((const char **)new_user);
ppm->insertItem(new__user,i18n("Register &new user"), 15);
ppm->insertSeparator();
QPixmap find;
find = loader->loadIcon("viewmag", KIcon::Small);
ppm->insertItem(find, i18n("&Search for users"), 7);
ppm->insertItem(i18n("I&mport userlist"), 18);
ppm->insertItem(i18n("E&xport userlist"), 20);
ppm->insertItem(QPixmap((const char **)gg_act_xpm),i18n("&Add user"), 9);
ppm->insertSeparator();
ppm->insertItem(i18n("A&bout..."), 11);
ppm->insertSeparator();
ppm->insertItem(i18n("&Hide Kadu"), 21);
ppm->insertItem(loader->loadIcon("exit", KIcon::Small), i18n("&Exit Kadu"), 16);

mmb = new KMenuBar(this);
mmb->insertItem(i18n("&Kadu"), ppm);
mmb->polish();

connect(ppm, SIGNAL( activated(int) ), this, SLOT( commandParser(int) ));

}

void Kadu::closeEvent(QCloseEvent *e) {
	if (!close_permitted && config.dock) {
	e->ignore();
	this->hide(); }
	else {

  this->saveConfiguration();
	
	fprintf(stderr,"KK closeEvent(): Graceful shutdown...\n");

	e->accept();
	}
	}

void Kadu::saveConfiguration(void) {
  fprintf(stderr,"KK saveConfiguration(): Writing config files...\n");
	KConfig * konf;
	konf = new KConfig(prepare_path("kadu.conf"));
	konf->setGroup("Global");
	konf->writeEntry("UIN",config.uin);
	konf->writeEntry("Password",pwHash(config.password));
//	konf->writeEntry("Password",config.password);
	konf->writeEntry("Geometry",kadu->geometry());
	konf->writeEntry("Message_sound",config.soundmsg);
	konf->writeEntry("Chat_sound",config.soundchat);
	konf->writeEntry("Logging",config.logmessages);
	konf->writeEntry("DefaultStatus",config.defaultstatus);
	konf->writeEntry("SystemMsgIndex",config.sysmsgidx);
	konf->writeEntry("SaveGeometry",config.savegeometry);
	konf->writeEntry("PlaySoundChat",config.playsoundchat);
	konf->writeEntry("PlaySoundChatInvisible",config.playsoundchatinvisible);
	konf->writeEntry("SoundPlayer",config.soundprog);
	konf->writeEntry("PlaySound",config.playsound);
	konf->writeEntry("PlaySoundArtsDsp",config.playartsdsp);
	konf->writeEntry("SoundVolume",config.soundvol);
	konf->writeEntry("VolumeControl",config.soundvolctrl);
	konf->writeEntry("AutoAway",config.autoaway);
	konf->writeEntry("AutoAwayTime",config.autoawaytime);
	konf->writeEntry("AllowDCC",config.allowdcc);
	konf->writeEntry("UseDocking",config.dock);
  konf->writeEntry("AutoRaise",config.raise);

	konf->setGroup("SMS");
	konf->writeEntry("SmsApp",config.smsapp);
	konf->writeEntry("SmsString",config.smsconf);
	konf->writeEntry("UseCustomString",config.smscustomconf);

	konf->setGroup("Other");
	konf->writeEntry("UseEmoticons",config.emoticons);
	konf->writeEntry("AutoSend",config.autosend);
	konf->writeEntry("ScrollDown",config.scrolldown);
	konf->writeEntry("EmoticonsPath",config.emoticonspath);
	konf->writeEntry("ChatPrune",config.chatprune);
	konf->writeEntry("ChatPruneLen",config.chatprunelen);

  konf->setGroup("Proxy");
  konf->writeEntry("UseProxy",config.useproxy);
  konf->writeEntry("ProxyHost",config.proxyaddr);
  konf->writeEntry("ProxyPort",config.proxyport);

	konf->setGroup("Notify");
	konf->writeEntry("NotifyUsers",config.notifies);
	konf->writeEntry("NotifySound",config.soundnotify);
	konf->writeEntry("NotifyStatusChange",config.notifyglobal);
	konf->writeEntry("NotifyWithDialogBox",config.notifydialog);
	konf->writeEntry("NotifyWithSound",config.notifysound);

	konf->sync();
  delete konf;
}

char * pwHash(const char *tekst) {
  char * nowytekst;
  nowytekst = strdup(tekst);
  int ile, znak;
  for (ile = 0; ile < strlen(tekst); ile++) {
    znak = nowytekst[ile]^ile^1;
    nowytekst[ile]=znak;
    }

  return nowytekst;
}

#include "kadu.moc"
