/***************************************************************************
                          kadu.h  -  description
                             -------------------
    begin                : wto sie 21 18:35:52 CEST 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KADU_H
#define KADU_H

/** max acknowledgements pending **/
#define MAX_ACK 10

/** max chat window instances **/
#define MAX_CHATS 10

/** values below most probably need no alteration **/

#define KADU_VERSION 0.2.1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <klocale.h>
#include <qevent.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qcombobox.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qpoint.h>
#include <qlayout.h>
#include <qslider.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <qapplication.h>
#include <qhbuttongroup.h>
#include <kfiledialog.h>
#include <qradiobutton.h>
#include <ksystemtray.h>
#include <qtextview.h>
#include <ktextbrowser.h>
#include <qtooltip.h>
#include <qfile.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qfont.h>
#include <qcursor.h>
#include <qmessagebox.h>
#include <qhgroupbox.h>
#include <qprocess.h>
#include <qsocketnotifier.h>
#include <qprogressdialog.h>
#include <qregexp.h>
#include <qlistview.h>
#include <qtabdialog.h>
#include <qstrlist.h>
#include <qgroupbox.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <qcheckbox.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <qaccel.h>
#include <qpainter.h>
#include <qmenubar.h>
#include <iostream>

#include <pthread.h>
#include <ctype.h>
#include <errno.h>

#include <pwd.h>
#include <sys/stat.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qtimer.h>

#include <sys/wait.h>
#include <sys/socket.h>

#include "history.h"
#include "pixmaps.h"

#include "../ekg/lib/libgadu.h"

// #define GG_STATUS_NOT_AVAIL 0x0001	/* rozczony */
//#define GG_STATUS_AVAIL 0x0002		/* dostpny */
//#define GG_STATUS_BUSY 0x0003		/* zajty */
//#define GG_STATUS_BUSY_DESCR 0x0004
//#define GG_STATUS_NOT_AVAIL_DESCR 0x0015 */
#define GG_STATUS_INVISIBLE2 0x0009 /* gupy... */
//#define GG_STATUS_AVAIL_DESCR 0x0005
//#define GG_STATUS_INVISIBLE_DESCR 0x0016 /* niewidoczny z opisem*/

#define __c2q(__char_pointer__) QString::fromLocal8Bit(__char_pointer__)

struct userlist {
	char *first_name, *last_name, *nickname, *comment, *mobile, *group;
	QString * description;
	uin_t uin;
	unsigned int status;
	bool anonymous;
	int ip;
	short port;
};

struct pending {
	uin_t uin;
	QString * msg;
	int msgclass;
};

struct colors {
 int userboxBgR;
 int userboxBgG;
 int userboxBgB;
 int userboxFgR;
 int userboxFgG;
 int userboxFgB;
 char * userboxFont;
 int userboxFontSize;
};


struct config {
	uin_t uin;
	char *password;
	char *soundmsg;
	char *soundchat;
	char *soundprog;
	double soundvol;
	bool soundvolctrl;
	bool playartsdsp;
	bool playsound;
	bool logmessages;
	bool savegeometry;
	bool playsoundchat;
	bool playsoundchatinvisible;
	int defaultstatus;
	int sysmsgidx;
	bool allowdcc;
	bool dock;

	char * smsapp;
	bool smscustomconf;
	char * smsconf;

	bool emoticons;
	char *emoticonspath;
	bool autosend;
	bool scrolldown;
	int chatprunelen;
	bool chatprune;

	bool autoaway;
	int autoawaytime;

  QStringList notifies;
	char *soundnotify;
	bool notifyglobal;
	bool notifydialog;
	bool notifysound;

  bool useproxy;
  char * proxyaddr;
  unsigned short proxyport;

  bool raise;

  struct colors colors;

};

struct groups {
  int number;
  char * name;
};

int UserToUin(const char *);
uin_t newUserToUin(const QString *);
QString newUserToMobile(const QString *);
char * UinToUser(uin_t);
int readUserlist(void);
void readConfig(void);
extern "C" { void send_userlist(void); }
void * watch_socket (void *);
void kadu_debug(int,char*);
void removeUser(const char *, bool);
char * prepare_path(char *);
void confirmHistoryDeletion(const char *);
int write_userlist(char *);
void playSound(char *);
void prepareDcc(void);

char * pwHash(const char *);

class Kadu : public QWidget
{
  Q_OBJECT 
  public:
		QTimer * autoaway;
    Kadu(QWidget* parent=0, const char *name=0);
    ~Kadu();
		bool autoawayed;
		bool autohammer;
		void syncUserlist(void);
    bool userInActiveGroup(uin_t uin);

	protected:
		void enterEvent (QEvent *);
		void closeEvent (QCloseEvent *);	
    void showEvent (QShowEvent * e);

		void watchDcc(void);
		struct timeval dcc_tv;
		struct gg_event *dcc_e;
		fd_set dcc_rd, dcc_wd;
		int dcc_ret;

    int activegrpno;

    bool blinkOn;
    bool doBlink;

	public slots:
    void blink();
		void slotHandleState(const QString & str);
		void sendMessage(QListBoxItem *);
		void listPopupMenu(QListBoxItem *);
		void commandParser(int);
		void sortUsers(void);
		void nConnect(void);
		void autoAway(void);
		void cleanUp(void);
		void pingNetwork(void);
		void checkConnection(void);
		void setOnline (void);
		void setAway (bool=false);
		void setInvisible (void);
		void disconnectNetwork(void);
    void saveConfiguration(void);
    void changeGroup(int);

	private:
		KMenuBar * mmb;
    int commencing_startup;
		void createMenu();
		bool close_permitted;

};

class Message : public QDialog {
	Q_OBJECT
		QPushButton * sendbtn;
		int index;
		QString nicksnd;
		QMultiLineEdit * body;	
		QLabel * nicknamelab;
		QDialog * sendmessage;
		QRadioButton * b_chat;
	public:
		Message(const QString &, bool tchat=false, QDialog* parent=0, const char *name=0);
	
	public slots:
		void gotAck(void);
		void commitSend(void);
		void HistoryBox(void);		
	
	protected slots:
		void accept();
		void reject();

	protected:
		void closeEvent(QCloseEvent *);

};

class IconSelector;

class CustomInput;

class Chat : public QDialog {
	Q_OBJECT
		int index;
		int totaloccurences;
		QString nick;
		QDialog * chatdlg;
		IconSelector * iconsel_ptr;
		QPushButton * iconsel;
  	QPushButton * autosend;
		QAccel * acc;
		QPushButton * sendbtn;
		void pruneWindow(void);

	public:
		Chat(const QString &, QDialog* parent=0, const char *name=0);
		~Chat();
		KTextBrowser * body;
  	int checkPresence(uin_t, unsigned char *, time_t,int formats_count=0,struct gg_msg_format * formats=NULL);
		void addEmoticon(QString);
		CustomInput * edit;
		QHBox * buttontray;
		bool autosend_enabled;

	public slots:
		void HistoryBox(void);
		void sendMessage(void);
		void cleanUp(void);

	protected:
		void closeEvent(QCloseEvent *);
		void alertNewMessage(void);
		QString convertCharacters(QString);
		void getFormatting(QString&,int formats_count,struct gg_msg_format * formats);
		QString putFormatting(QString);

	private slots:
		void timerReset(void);
		void userWhois(void);
		void insertEmoticon(void);
		void regAutosend(void);
};

class CustomInput : public QMultiLineEdit {
  Q_OBJECT
  public:
   CustomInput(Chat* parent=0, const char *name=0);
   friend class Chat;

  private:
    Chat * tata;

	protected:
		void keyPressEvent(QKeyEvent * e );

};


struct chats {
	unsigned int uin;
	Chat * ptr;
};

struct acks {
	int seq;
	Message * ptr;
};

class ConfigDialog : public QTabDialog	{
    Q_OBJECT

public:
    ConfigDialog(QWidget *parent=0, const char *name=0);

protected:
    void setupTab1();
    void setupTab2();
		void setupTab3();
		void setupTab4();
		QCheckBox * b_geometry;
		QCheckBox * b_logging;
		QLineEdit * e_password;
		QLineEdit * e_uin;
		QLineEdit * e_smsapp;
		QLineEdit * e_smsconf;
		QCheckBox * b_smscustomconf;
		QCheckBox * b_autoaway;
		QLineEdit * e_autoawaytime;
		QCheckBox * b_dock;
		
		QLineEdit * e_soundprog;
		QCheckBox * b_playsound;
		QCheckBox * b_playartsdsp;
		QLineEdit * e_msgfile;
		QLineEdit * e_chatfile;
		QCheckBox * b_playchat;
		QCheckBox * b_playchatinvisible;
		QSlider * s_volume;
		QCheckBox * b_soundvolctrl;

		QCheckBox * b_emoticons;
		QCheckBox * b_autosend;
		QCheckBox * b_scrolldown;
		QLineEdit * e_emoticonspath;
		QCheckBox * b_chatprune;
		QLineEdit * e_chatprunelen;

		QListBox * e_notifies;
		QListBox * e_availusers;
		QCheckBox * b_notifyglobal;
		QCheckBox * b_notifydialog;
		QCheckBox * b_notifysound;
		QLineEdit * e_soundnotify;

protected slots:
		void _Left();
		void _Right();
		void updateConfig();
		void chooseMsgFile();
		void chooseChatFile();
		void choosePlayerFile();
		void chooseNotifyFile();
		void chooseEmoticonsPath();
		void emoticonsEnabled(bool);

};

class DockWidget : public KSystemTray  {
   Q_OBJECT

 public:
   DockWidget(QWidget *parent=0, const char *name=0);
   void DockWidget::setActive(void);
   void DockWidget::setInactive(void);
   void DockWidget::setInvisible(void);
	 void DockWidget::setBusy(void);
	 void DockWidget::setBusyDescr(void);
	 void DockWidget::setMsg(void);

	protected:
		void mousePressEvent (QMouseEvent*);

};


class rMessage : public QDialog {
	Q_OBJECT
	private:
		QString sender;
		QMultiLineEdit * body;	
		QLabel * lejbel;
		QDialog * recvmsg;
		bool tchat;
	public:
		rMessage(const QString &, int, QDialog *parent=0, const char *name=0);

	public slots:
		void replyMessage(void);
		void openChat(void);
		void cleanUp(void);

};

class HistorybBox : public QDialog {
	Q_OBJECT
	public:
		HistorybBox(uin_t);
	
	protected:
		QMultiLineEdit * body;
};

class UserInfo : public QDialog {
	Q_OBJECT
	public:
		UserInfo(const QString &, QDialog* parent=0, unsigned int uin = 0);
	private:
		unsigned int this_index;
		QLineEdit *firstname, *nickname, *e_lastname, *e_comment, *e_mobile, *e_uin, *e_addr, *e_group;		

	private slots:
		void writeUserlist();

};

class UserlistImport : public QDialog {
	Q_OBJECT
	public:
		UserlistImport(QDialog* parent=0, const char *name=0);

	private:
		struct gg_http * gg_http;
		struct timeval tv;
		struct gg_event *e;
		fd_set rd, wd;
		int ret;
		QTimer * stimer;
		QArray<userlist> importedusers;
		QPushButton * fetchbtn;
		bool struct_freed;
	
	protected:
		QListView * results;


	private slots:
		void socketEvent(void);
		void startTransfer(void);
		void updateUserlist(void);

	protected:
		void closeEvent(QCloseEvent * e);

};

class UserlistExport : public QDialog {
	Q_OBJECT
	public:
		UserlistExport(QDialog* parent=0, const char *name=0);

	private:
		struct gg_http * gg_http;
		struct timeval tv;
		struct gg_event *e;
		fd_set rd, wd;
		int ret;
		QTimer * stimer;
		QPushButton * sendbtn;
		bool struct_freed;

	private slots:
		void socketEvent(void);
		void startTransfer(void);

	protected:
		void closeEvent(QCloseEvent * e);

};

class SearchDialog : public QDialog {
	Q_OBJECT
	public:
		SearchDialog(QDialog* parent=0, const char *name=0, uin_t whoisSearchUin = 0);

	private:
    struct gg_http *foo;
    struct gg_search *res;
    struct gg_search_request r;

		QCheckBox * only_active;
		QLineEdit * e_name;
		QLineEdit * e_nick;
		QLineEdit * e_byr;
		QLineEdit * e_surname;
		QComboBox * c_gender;
		QLineEdit * e_city;
		QListView * results;
		QLabel * progress;
		QRadioButton * r_uin;
		QRadioButton * r_pers;
		QRadioButton * r_phone;
		QRadioButton * r_mail;
		QPushButton * b_sendbtn;
		
    uin_t _whoisSearchUin;
    bool commencing_startup;

		QLineEdit * e_phone;
		QLineEdit * e_mail;
		QLineEdit * e_uin;

		struct timeval tv;
		struct gg_event *e;
		fd_set rd, wd;
		int ret;
		QTimer * stimer;
		bool struct_freed;

	private slots:
		void socketEvent(void);
		void clearResults(void);
		void prepareMessage(QListViewItem*);
		void mailTyped(void);
		void uinTyped(void);
		void phoneTyped(void);

	public slots:
		int doSearch(void);

	protected:
		void closeEvent(QCloseEvent * e);
    void showEvent (QShowEvent * e);

};
		
class Operation : public QProgressDialog {
	Q_OBJECT
	public:
	Operation(const QString & labelText, const QString & cancelButtonText, int totalSteps, QWidget *parent = 0 );
	int laststate;
	QTimer * t;
	int steps;

	private slots:
	void perform();
	void cancel();
};

class Adduser : public QDialog {
	Q_OBJECT
	public:
		Adduser(QDialog* parent=0, const char *name=0);

	protected:
		QLineEdit * e_nickname, * e_uin, * e_fname, * e_lname, * e_altnick, * e_tel;
		QLabel * effect;

	protected slots:
		void Add();
};

class Ignored : public QDialog {
	Q_OBJECT
	public:
		Ignored(QDialog* parent=0, const char *name=0);

	private:
		QListBox * list;
		QLineEdit * e_uin;

	private slots:
		void remove();
		void add();
		void getList();	
};

class About : public QDialog {
 Q_OBJECT
	public:
		About(QDialog* parent=0, const char *name=0);

};

class Sms : public QDialog {
 Q_OBJECT
	public:
		Sms(unsigned int gsmno = 0, const QString & = "sms", QDialog* parent=0);

	private:
		QMultiLineEdit * body;
		QLineEdit * recipient;
		QLabel * smslen;
		QPushButton * b_send;
    QProcess * smsProcess;

	private slots:
		void updateRecipient(const QString &);
		int sendSms();
		void updateCounter();
    void smsSigHandler();

};

class DccGet : public QDialog {
	Q_OBJECT
	public:
		DccGet(struct gg_dcc * dcc_ptr = 0, QDialog* parent=0, const char *name=0);

	protected:
		struct timeval dcc_tv;
		struct gg_event *dcc_e;
		struct gg_dcc * dccsock;
		fd_set dcc_rd, dcc_wd;
		int dcc_ret;
		QTimer * stimer;
		FILE * file_write;
		long long int numshots;
		long long int prev_offset;

		QLabel * l_offset;
		QProgressBar * p_progress;
		QString tmptxt;
		QVBox * vbox1;

		void prepareToWrite(void);

	protected slots:
		void askAccept(void);
		void watchSocket(void);
  	
};

class Register : public QDialog {
	Q_OBJECT
	public:
		Register(QDialog* parent=0, const char *name=0);

	private:
		QTimer * sokiet;
		struct gg_http *h;
		struct gg_pubdir *p;
		QLineEdit * pwd, * pwd2, * mail;
		QLabel * status;
		uin_t uin;
  	void ask();	
		QCheckBox * updateconfig;

	private slots:
		void doRegister();
		void watchSocket();
};

class IconSelector : public QWidget {
	Q_OBJECT
	public:
		IconSelector(QWidget* parent=0, const char *name=0, Chat *caller=0);

	private:
		Chat * callingwidget;

	private slots:
		void slot_1_1();
		void slot_1_2();
		void slot_1_3();
		void slot_1_4();

		void slot_2_1();
		void slot_2_2();
		void slot_2_3();
		void slot_2_4();

		void slot_3_1();
		void slot_3_2();
		void slot_3_3();
		void slot_3_4();

		void slot_4_1();
		void slot_4_2();
		void slot_4_3();
		void slot_4_4();

};

class MyListBox : public QListBox , QToolTip {
	Q_OBJECT
	public:
      MyListBox ( QWidget * parent=0, const char * name=0, WFlags f=0 );
		 virtual void clear() { QListBox::clear(); };

	protected:
	   virtual void maybeTip(const QPoint&);
		 int descriptionForUser(QListBoxItem *);

};


class ChooseDescription : public QDialog {
	Q_OBJECT
	public:
	ChooseDescription::ChooseDescription ( QWidget * parent=0, const char * name=0);

	private:
		QMultiLineEdit * desc;

	private slots:
		void okidokiPressed();

};


void createKonfig(char *, uin_t);
void addIgnored(uin_t);
void delIgnored(uin_t);
bool isIgnored(uin_t);
int writeIgnored(char *);
void remindPassword();

#endif
