/***************************************************************************
                          network.cpp  -  description
                             -------------------
    begin                : Tue Oct 2 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kadu.h"

extern QString own_description;
extern struct gg_session sess;
extern int last_ping;
extern bool userlist_sent;
extern bool socket_active;
extern QComboBox * mycombo;
extern Kadu * kadu;
extern Operation * progresswindow;

	/* progress bar, now isn't the name self-explanatory? :> */
  Operation::Operation(const QString & labelText, const QString & cancelButtonText, int totalSteps, QWidget *parent )
: QProgressDialog(labelText, cancelButtonText, totalSteps, parent)
  {
			steps = 1;
      connect( this, SIGNAL(cancelled()), this, SLOT(cancel()) );
			this->setLabelText("Connecting");
      t = new QTimer( this );
      connect( t, SIGNAL(timeout()), this, SLOT(perform()) );
      laststate = 0;
      t->start(50);
			this->setAutoClose(true);
			this->setAutoReset(true);

  }

  void Operation::perform()
  {
	if (sess.state == laststate) return;

	switch (sess.state) {
			case GG_STATE_RESOLVING:
				laststate = GG_STATE_RESOLVING;
				this->setLabelText("Resolving address");
				this->setProgress(1);
				break;
			case GG_STATE_CONNECTING_HUB:
				laststate = GG_STATE_CONNECTING_HUB;
				this->setLabelText("Connecting to hub");
				this->setProgress(2);
				break;
			case GG_STATE_READING_DATA:
				laststate = GG_STATE_READING_DATA;
				this->setLabelText("Fetching data from hub");
				this->setProgress(3);
				break;
			case GG_STATE_CONNECTING_GG:
				laststate = GG_STATE_CONNECTING_GG;
				this->setLabelText("Connecting to server");
				this->setProgress(4);
				break;
			case GG_STATE_READING_KEY:
				laststate = GG_STATE_READING_KEY;
				this->setLabelText("Waiting for hash key");
				this->setProgress(5);
				break;
			case GG_STATE_READING_REPLY:
				laststate = GG_STATE_READING_KEY;
				this->setLabelText("Sending key");
				this->setProgress(6);
				break;
			default:
				this->setProgress(7);
        t->stop();
				break;
			}

  }

  void Operation::cancel()
  {
			kadu->disconnectNetwork();
			mycombo->setCurrentItem(3);
      t->stop();
      progresswindow = NULL;
  }

ChooseDescription::ChooseDescription ( QWidget * parent, const char * name) :
		QDialog(parent, name, true) {
this->setWFlags(Qt::WDestructiveClose);
this->setCaption(i18n("Select description"));
desc = new QMultiLineEdit(this);

QPushButton * okidoki;
okidoki = new QPushButton(this);
okidoki->setText(i18n("OK"));
okidoki->setIconSet(QIconSet( QPixmap((const char**)gg_busydescr_xpm) ));

QObject::connect(okidoki, SIGNAL( clicked() ), this, SLOT( okidokiPressed() ));

QGridLayout * grid = new QGridLayout(this, 2,2);

grid->addMultiCellWidget(desc,0,0,0,1);
grid->addWidget(okidoki,1,1,Qt::AlignRight);
grid->addColSpacing(0,200);

this->resize(250,150);
this->exec();

}

void ChooseDescription::okidokiPressed() {
	own_description = desc->text();
	this->close(true);
	}

