/***************************************************************************
                          search.cpp  -  description
                             -------------------
    begin                : Thu Sep 27 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include "search.h"

extern void cp_to_iso(unsigned char *);

SearchDialog::SearchDialog(QDialog *parent, const char *name, uin_t whoisSearchUin) : QDialog (parent, name) {
this->resize(450,330);
this->setCaption(i18n("Search in directory"));

_whoisSearchUin = whoisSearchUin;

struct_freed=false;

QLabel * l_name;
QLabel * l_nick;
QLabel * l_byr;
QLabel * l_surname;
QLabel * l_gender;
QLabel * l_city;
QLabel * l_mail;
QLabel * l_uin;
QLabel * l_phone;

b_sendbtn = new QPushButton(this);
b_sendbtn->setText(i18n("&Search"));
connect(b_sendbtn, SIGNAL( clicked() ), this, SLOT( doSearch() ));
b_sendbtn->setAccel(Key_Return);	

QPushButton * b_clrbtn;
b_clrbtn = new QPushButton(this);
b_clrbtn->setText(i18n("C&lear list"));

l_name = new QLabel(this);
l_name->setText(i18n("Name"));
e_name = new QLineEdit(this);

l_nick = new QLabel(this);
l_nick->setText(i18n("Nickname"));
e_nick = new QLineEdit(this);

l_byr = new QLabel(this);
l_byr->setText(i18n("Birthyear"));
e_byr = new QLineEdit(this);

l_surname = new QLabel(this);
l_surname->setText(i18n("Surname"));
e_surname = new QLineEdit(this);

l_gender = new QLabel(this);
l_gender->setText(i18n("Gender"));
c_gender = new QComboBox(this);
c_gender->insertItem(i18n(" "), 0);
c_gender->insertItem(i18n("Male"), 1);
c_gender->insertItem(i18n("Female"), 2);

l_city = new QLabel(this);
l_city->setText(i18n("City"));
e_city = new QLineEdit(this);

QGroupBox * qgrp2 = new QGroupBox(4, Qt::Horizontal, i18n("E-mail & phone"), this);
l_mail = new QLabel(qgrp2);
l_mail->setText(i18n("Mail"));
e_mail = new QLineEdit(qgrp2);
l_phone = new QLabel(qgrp2);
l_phone->setText(i18n("Phone"));
e_phone = new QLineEdit(qgrp2);

QGroupBox * qgrp1 = new QGroupBox(2, Qt::Horizontal, "Uin", this);
l_uin = new QLabel(qgrp1);
l_uin->setText(i18n("Uin"));
e_uin = new QLineEdit(qgrp1);

progress = new QLabel(this);

results = new QListView(this);
connect(b_clrbtn, SIGNAL( clicked() ), this, SLOT( clearResults() ));
connect(results, SIGNAL( doubleClicked(QListViewItem *) ), this, SLOT( prepareMessage(QListViewItem *) ));

QHButtonGroup * btngrp = new QHButtonGroup(this);
btngrp->setCaption(i18n("Search criteria"));
r_pers = new QRadioButton(btngrp);
r_pers->setText(i18n("&Personal data"));
r_pers->setChecked(true);
QToolTip::add(r_pers, i18n("Search using the personal data typed above (name, nickname)..."));

r_uin = new QRadioButton(btngrp);
r_uin->setText(i18n("&Uin"));
QToolTip::add(r_uin, i18n("Search for this UIN exclusively"));

r_phone = new QRadioButton(btngrp);
r_phone->setText(i18n("P&hone"));
QToolTip::add(r_phone, i18n("Search by phone"));

r_mail = new QRadioButton(btngrp);
r_mail->setText(i18n("&E-mail"));
QToolTip::add(r_mail, i18n("Search by e-mail"));

/* change radio buttons automagically if some fields are altered */
QObject::connect(e_phone, SIGNAL( textChanged(const QString &) ), this, SLOT( phoneTyped() ));
QObject::connect(e_mail, SIGNAL( textChanged(const QString &) ), this, SLOT( mailTyped() ));
QObject::connect(e_uin, SIGNAL( textChanged(const QString &) ), this, SLOT( uinTyped() ));


btngrp->insert(r_pers, 1);
btngrp->insert(r_uin, 2);
btngrp->insert(r_phone, 3);
btngrp->insert(r_mail, 4);

only_active = new QCheckBox(this);
only_active->setText(i18n("Only active users"));

QGridLayout * grid = new QGridLayout (this, 10, 7, 3, 3);
grid->addMultiCellWidget(only_active,0,0,1,3);
grid->addWidget(l_name,1,1); grid->addWidget(e_name,1,2);
grid->addWidget(l_nick,2,1); grid->addWidget(e_nick,2,2);
grid->addWidget(l_byr,3,1); grid->addWidget(e_byr,3,2);
grid->addWidget(l_surname,1,4); grid->addWidget(e_surname,1,5);
grid->addWidget(l_gender,2,4); grid->addWidget(c_gender,2,5);
grid->addWidget(l_city,3,4); grid->addWidget(e_city,3,5);

grid->addMultiCellWidget(qgrp1, 6,6,1,2);
grid->addMultiCellWidget(qgrp2, 6,6,3,5);

grid->addMultiCellWidget(btngrp, 7,7, 1, 5);

grid->addMultiCellWidget(results,8,8,1,5);
grid->addWidget(b_clrbtn,9,4);
grid->addWidget(b_sendbtn,9,5);
grid->addMultiCellWidget(progress,9,9,1,3);

grid->addColSpacing(2,100);
grid->addColSpacing(3,20);
grid->addColSpacing(0,10);
grid->addColSpacing(6,10);
grid->addRowSpacing(0,1);
grid->addRowSpacing(6,1);

results->addColumn(i18n(" "));
results->addColumn(i18n("Uin"));
results->addColumn(i18n("Name"));
results->addColumn(i18n("Surname"));
results->addColumn(i18n("City"));
results->addColumn(i18n("Nickname"));
results->addColumn(i18n("Birth year"));
results->setAllColumnsShowFocus(true);

/* dirty workaround for multiple showEvents */
commencing_startup = true;

this->show();
}

void SearchDialog::showEvent (QShowEvent * e) {

QWidget::showEvent(e);

if (_whoisSearchUin != 0 && commencing_startup) {
   r_uin->setChecked(true);
//	 char whois_uin[12];
//	 snprintf(whois_uin, sizeof(whois_uin), "%d", _whoisSearchUin);
//	 e_uin->setText(whois_uin);
   e_uin->setText(QString::number(_whoisSearchUin));
	 this->doSearch();
   commencing_startup = false;
	}

}

void SearchDialog::prepareMessage(QListViewItem * item) {
	new Message(UinToUser(atoi(item->text(1).local8Bit())));
	}

void SearchDialog::clearResults(void) {
	results->clear();
	}

int SearchDialog::doSearch(void) {

int i;

    b_sendbtn->setEnabled(FALSE);
	
	if (r_pers->isChecked()) {
	r.first_name = (char *) e_name->text().latin1();
  r.last_name = (char *) e_surname->text().latin1();
	r.nickname = (char *) e_nick->text().latin1();
	r.city = (char *) e_city->text().latin1();
	r.min_birth = atoi(e_byr->text().latin1());
	r.max_birth = atoi(e_byr->text().latin1());
	if (strcmp(c_gender->currentText().latin1(), " ") == 0)	r.gender = GG_GENDER_NONE;
	else if (strcmp(c_gender->currentText().latin1(), "Male") == 0)	r.gender = GG_GENDER_MALE;
	if (strcmp(c_gender->currentText().latin1(), "Female") == 0)	r.gender = GG_GENDER_FEMALE;
	r.phone = NULL;
	r.uin = 0;
	r.email = NULL;

	} else if (r_uin->isChecked()) {
	r.uin = atoi(e_uin->text().latin1());
	r.first_name = NULL;
	r.last_name = NULL;
	r.nickname = NULL;
	r.city = NULL;
	r.min_birth = 0;
	r.max_birth = 0;
	r.email = NULL;
	r.phone = NULL;
	r.gender = 0;	
	} else if (r_phone->isChecked()) {
	r.uin = 0;
	r.first_name = NULL;
	r.last_name = NULL;
	r.nickname = NULL;
	r.city = NULL;
	r.min_birth = 0;
	r.max_birth = 0;
	r.email = NULL;
	r.phone = (char *) e_phone->text().latin1();
	r.gender = 0;	
	} else if (r_mail->isChecked()) {
	r.uin = 0;
	r.first_name = NULL;
	r.last_name = NULL;
	r.nickname = NULL;
	r.city = NULL;
	r.min_birth = 0;
	r.max_birth = 0;
	r.email = (char *) e_mail->text().latin1();
	r.phone = NULL;
	r.gender = 0;	
	} // if r_pers

	if (only_active->isChecked())
		r.active = 1;
	else
		r.active = 0;

	progress->setText(i18n("Searching..."));
	fprintf(stderr, "SearchDialog::doSearch(): let the search begin\n");

	if (!(foo = gg_search(&r, 1))) {
		fprintf(stderr, "SearchDialog::doSearch(): gg_search() failed\n");
		QMessageBox::critical(this, "Search failed", i18n("The search failed due to an internal error") );
		progress->setText(i18n("Search failed"));
		return 1;
		}

		stimer = new QTimer(this);
		QObject::connect(stimer, SIGNAL(timeout()), this, SLOT(socketEvent()));		
		stimer->start(50, TRUE);

	return 0;
}

void SearchDialog::socketEvent(void) {

if (foo->state == GG_STATE_ERROR) {
	stimer->stop();
	QMessageBox::critical(this, "Search error", i18n("The application encountered a network error\nand was unable to complete the search") );
	progress->setText(i18n("Error searching"));
	b_sendbtn->setEnabled(TRUE);
	return;
	}

		FD_ZERO(&rd);
		FD_ZERO(&wd);
		bool dis2 = false;
//		struct gg_search *res;

		if ((foo->check & GG_CHECK_READ))
			FD_SET(foo->fd, &rd);
		if ((foo->check & GG_CHECK_WRITE))
			FD_SET(foo->fd, &wd);

		tv.tv_sec = 0;
		tv.tv_usec = 500;

		ret = select(foo->fd + 1, &rd, &wd, NULL, &tv);

		if (ret < 1) {
		    stimer->start(50, TRUE);	
		    return;
		} else { // begin main block


fprintf(stderr, "KK SearchDialog::socketEvent(): Data on socket\n");

if (foo->state == GG_STATE_DONE && (foo->data == NULL || res->results == NULL)) {
	fprintf(stderr, "KK SearchDialog::socketEvent(): No results. Exit.\n");
	QMessageBox::information(this, "No results", i18n("There were no results of your search") );
	gg_free_search(foo);
	struct_freed = true;
	b_sendbtn->setEnabled(TRUE);
        stimer->stop();	
	return;
	}

 if (gg_search_watch_fd(foo) < 0) {
	stimer->stop();
	fprintf(stderr,"KK SearchDialog::socketEvent(): gg_search_watch_fd() error. bailing out.\n");
	QMessageBox::critical(this, "Search error", i18n("The application encountered a network error\nand was unable to complete the search") );
	progress->setText(i18n("Error searching"));
	gg_free_search(foo);
	struct_freed = true;
	b_sendbtn->setEnabled(TRUE);
        stimer->stop();	
	return;
	}

if (foo->state == GG_STATE_DONE) {
  res = (struct gg_search *) foo->data;
  progress->setText(i18n("Done searching"));
	stimer->stop();
	char born[8];
	char uin[32];
	QListViewItem * qlv;
	QPixmap * qpx;
	for (int i = 0; i < res->count; i++) {
		printf("%d: %s %s (%s), %d, %s, status %d\n", res->results[i].uin, res->results[i].first_name, res->results[i].last_name, res->results[i].nickname, res->results[i].born, res->results[i].city, res->results[i].active);
		if (res->results[i].born != 0)
			snprintf(born, sizeof(born), "%d", res->results[i].born);
		else
			snprintf(born, sizeof(born), "?");

		snprintf(uin, sizeof(uin), "%d", res->results[i].uin);

		if (res->results[i].active != 0)
			qpx = new QPixmap((const char **)gg_act_xpm);
		else if (res->results[i].active == 0 && only_active->isChecked())
 			qpx = new QPixmap((const char **)gg_busy_xpm);
		else
 			qpx = new QPixmap((const char **)gg_inact_xpm);

		/* /me stoopid, or some fields break the conversion? */
		/* cp_to_iso((unsigned char *) res->results[i].first_name);
		cp_to_iso((unsigned char *) res->results[i].last_name);
		cp_to_iso((unsigned char *) res->results[i].nickname);
		cp_to_iso((unsigned char *) res->results[i].city); */
		qlv = new QListViewItem(results, QString::null, uin, __c2q(res->results[i].first_name), res->results[i].last_name, __c2q(res->results[i].city), __c2q(res->results[i].nickname), born);
		qlv->setPixmap(0, *qpx);
		
	}
	gg_free_search(foo);
	struct_freed = true;
	b_sendbtn->setEnabled(TRUE);
        stimer->stop();	
	return;

} // end main block
    stimer->start(50, TRUE);
}


}

void SearchDialog::closeEvent(QCloseEvent * e) {
	if (!struct_freed) {
		stimer->stop();
		gg_free_search(foo);
		struct_freed = true;
		}	
	QWidget::closeEvent(e);
	}

void SearchDialog::phoneTyped(void) {
r_phone->setChecked(true);
}

void SearchDialog::mailTyped(void) {
r_mail->setChecked(true);
}

void SearchDialog::uinTyped(void) {
r_uin->setChecked(true);
}
