/***************************************************************************
                          userinfo.cpp  -  description
                             -------------------
    begin                : Tue Oct 9 2001
    copyright            : (C) 2001 by tomee
    email                : tomee@cpi.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kadu.h"
#include <qfile.h>

extern QArray<userlist> userlist;
extern QArray<groups> grouplist;
extern Kadu * kadu;
extern MyListBox * mylist;
extern bool userlist_sent;
extern QArray<uin_t> ignored;
extern struct gg_session sess;

UserInfo::UserInfo (const QString & name, QDialog* parent , unsigned int uin) : QDialog (parent, name) {
	this->resize(240,200);
	this->setCaption(i18n("User info on %1").arg(__c2q(UinToUser(uin))));
	this->setWFlags(Qt::WDestructiveClose);

	QLineEdit * e_status = new QLineEdit(this);
	QLabel * l_status = new QLabel(this);
	l_status->setText(i18n("Status"));

  nickname = new QLineEdit(this);
	QLabel * l_nickname = new QLabel(this);
	l_nickname->setText(i18n("Nickname"));

	firstname = new QLineEdit(this);
	QLabel * l_firstname = new QLabel(this);
	l_firstname->setText(i18n("First name"));

	e_uin = new QLineEdit(this);
	QLabel * l_uin = new QLabel(this);
	l_uin->setText(i18n("Uin"));

	e_lastname = new QLineEdit(this);
	QLabel * l_lastname = new QLabel(this);
	l_lastname->setText(i18n("Surname"));

	e_mobile = new QLineEdit(this);
	QLabel * l_mobile = new QLabel(this);
	l_mobile->setText(i18n("Mobile"));

	e_group = new QLineEdit(this);
	QLabel * l_group = new QLabel(this);
	l_group->setText(i18n("Group"));

	e_comment = new QLineEdit(this);
	QLabel * l_comment = new QLabel(this);
	l_comment->setText(i18n("Orig.nick"));

	e_addr = new QLineEdit(this);
	QLabel * l_addr = new QLabel(this);
	l_addr->setText(i18n("Address"));
	e_addr->setReadOnly(true);

	nickname->setText(__c2q(UinToUser(uin)));

	QPushButton * update = new QPushButton(this);
	update->setText(i18n("Write userlist"));
	connect(update, SIGNAL( clicked() ), this, SLOT( writeUserlist() ));

	int i;
	for (i = 0; i < userlist.size(); i++) {
		if (userlist[i].uin == uin) break;
	}
	this_index = i;

	firstname->setText(QString(userlist[i].first_name));
	e_lastname->setText(QString(userlist[i].last_name));
	e_comment->setText(QString(userlist[i].comment));
	e_mobile->setText(QString(userlist[i].mobile));	

  e_group->setText(__c2q(userlist[i].group));

	if (userlist[i].ip != 0) {
	struct in_addr in;
  in.s_addr = userlist[i].ip;
	char address[128];
	snprintf(address, sizeof(address), "%s:%d", inet_ntoa(in), userlist[i].port);
	e_addr->setText(i18n(address));
	} else
	e_addr->setText(i18n("(Unknown)"));

	switch (userlist[i].status) {
		case GG_STATUS_AVAIL:
			e_status->setText(i18n("Online")); break;
		case GG_STATUS_AVAIL_DESCR:
			e_status->setText(i18n("Online (d.)")); break;
		case GG_STATUS_NOT_AVAIL:
			e_status->setText(i18n("Offline")); break;
		case GG_STATUS_BUSY:
			e_status->setText(i18n("Away")); break;
		case GG_STATUS_BUSY_DESCR:
			e_status->setText(i18n("Away (d.)")); break;
		case GG_STATUS_INVISIBLE2:
			e_status->setText(i18n("Invisible")); break;
		}

	if (!userlist_sent)
		e_status->setText(i18n("(Unknown)"));
	
	e_status->setReadOnly(true);
	e_status->setEnabled(false);

	e_uin->setText(QString::number(userlist[i].uin));
	e_uin->setReadOnly(true);
	e_uin->setEnabled(false);

	QPushButton * kloze = new QPushButton(this);
	kloze->setText(i18n("Close"));
	connect(kloze, SIGNAL( clicked() ), this, SLOT( close() ));

	QGridLayout * grid = new QGridLayout(this, 10,2,10,3);
	grid->addColSpacing(0,80);
	grid->addWidget(l_uin,0,0);
	grid->addWidget(e_uin,0,1);
	grid->addWidget(l_status,1,0);
	grid->addWidget(e_status,1,1);
	grid->addWidget(l_nickname,2,0);
	grid->addWidget(nickname,2,1);
	grid->addWidget(l_firstname,3,0);
	grid->addWidget(firstname,3,1);
	grid->addWidget(l_lastname,4,0);
	grid->addWidget(e_lastname,4,1);
	grid->addWidget(l_comment,5,0);
	grid->addWidget(e_comment,5,1);
	grid->addWidget(l_mobile,6,0);
	grid->addWidget(e_mobile,6,1);
	grid->addWidget(l_group,7,0);
	grid->addWidget(e_group,7,1);
	grid->addWidget(l_addr,8,0);
	grid->addWidget(e_addr,8,1);
	grid->addWidget(kloze,9,0);
	grid->addWidget(update,9,1);	
	this->show();
	}

void UserInfo::writeUserlist() {
 bool yes = false;
 switch( QMessageBox::information( kadu, "Kadu",i18n("This will write current userlist"),"Cancel", "OK", 0, 0, 1) ) {
 case 1: // Yes?
			fprintf(stderr, "KK UserInfo::writeUserlist(): this_index: %d\n", this_index);
		  userlist[this_index].first_name = strdup(firstname->text().local8Bit());
			userlist[this_index].last_name = strdup(e_lastname->text().local8Bit());
			userlist[this_index].nickname = strdup(nickname->text().local8Bit());			
      userlist[this_index].group = strdup(e_group->text().local8Bit());
			if (e_comment->text().latin1() != NULL)
				userlist[this_index].comment = strdup(e_comment->text().local8Bit());
			else
				userlist[this_index].comment = "";
			if (!userlist[this_index].anonymous)
				userlist[this_index].mobile = strdup(e_mobile->text().local8Bit());
			write_userlist(NULL);

      for (int i = 0; i < grouplist.size(); i++) {
        if (QString::compare(__c2q(grouplist[i].name), __c2q(userlist[this_index].group)) == 0) {
          yes = true;
          break;
          }
        }

      if (!yes) {
       grouplist.resize(grouplist.size()+1);
       if (grouplist.size() > 1)
          grouplist[grouplist.size()-1].number = grouplist[grouplist.size()-2].number + 1;
       else
          grouplist[grouplist.size()-1].number = 601;
       grouplist[grouplist.size()-1].name = strdup(userlist[this_index].group);

      }

			kadu->syncUserlist();

			break;
  case 0:
			return;	
	}
}

void removeUser(const char * username, bool permanently= false) {
		int tmpuin = UserToUin(username);

		int i = 0;
		while (strcmp(mylist->item(i)->text().local8Bit(),username) != 0) i++;

		if (strcmp(mylist->item(i)->text().local8Bit(),userlist[i].nickname) != 0) {
			fprintf(stderr, "KK removeUser(): FATAL: QListBox and userlist[] out of sync! Returning!\n");
			return;
			}

		gg_remove_notify(&sess, userlist[i].uin);
		free(userlist[i].first_name);
		userlist[i].first_name = NULL;
		free(userlist[i].last_name);
		userlist[i].last_name = NULL;
		free(userlist[i].nickname);
		userlist[i].nickname = NULL;
		free(userlist[i].comment);
		userlist[i].comment = NULL;
		free(userlist[i].mobile);
		userlist[i].mobile = NULL;
		free(userlist[i].group);	
		userlist[i].group = NULL;
  	userlist[i].anonymous = false;
    if (userlist[i].description != NULL) {
  		delete userlist[i].description;
  		userlist[i].description = NULL;
      }

		mylist->removeItem(i);

		int k;
		for (k = i; k < userlist.size() - 1; k++) {
      userlist[k] = userlist[k+1];
			}

		userlist.resize(userlist.size() - 1);
		kadu->syncUserlist();

		fprintf(stderr, "KK removeUser(): new userlist status\n");
		for (int i = 0; i < mylist->count(); i++) {
			fprintf(stderr, "KK Index %d / Nickname %s / Display %s / Uin %d / Status %d\n", i, userlist[i].nickname,
				mylist->item(i)->text().latin1(), userlist[i].uin, userlist[i].status);
			}
		fprintf(stderr, "KK removeUser(): if you spot any inconsistency, report!\n");

  switch( QMessageBox::information( kadu, "Kadu",i18n("Save current userlist to file?"),"No", "Yes", 0, 0, 1) ) {
 case 1: // Yes?
			write_userlist(NULL);
			break;
  case 0:
			return;
  }
}

int write_userlist(char *filename=NULL)
{
	char *tmp;

	if (!(tmp = prepare_path("")))
		return -1;
	mkdir(tmp, 0700);

	if (filename==NULL) {
		if (!(filename = prepare_path("userlist")))
			return -1;
	}

  QFile f(filename);

  if (!f.open(IO_WriteOnly)) {
    std::cout << "KK write_userlist(): Error opening file :(" << std::endl;
    return -2;
    }

/*  someone tell me how. */
//	fchmod(fileno(f), 0600);

    QString jakisstr;
	for (int i = 0; i < userlist.size(); i++) {
    if (userlist[i].uin == 0 || userlist[i].nickname == NULL)
      break;

    jakisstr.truncate(0);

    jakisstr.append(__c2q(userlist[i].first_name));
    jakisstr.append(QString(";"));
    jakisstr.append(__c2q(userlist[i].last_name));
    jakisstr.append(QString(";"));
    jakisstr.append(__c2q(userlist[i].comment));
    jakisstr.append(QString(";"));
    jakisstr.append(__c2q(userlist[i].nickname));
    jakisstr.append(QString(";"));
    jakisstr.append(__c2q(userlist[i].mobile));
    jakisstr.append(QString(";"));
    jakisstr.append(__c2q(userlist[i].group));
    jakisstr.append(QString(";"));
    jakisstr.append(QString::number(userlist[i].uin));
    jakisstr.append(QString("\r\n"));

    std::cout << jakisstr;

    f.writeBlock(jakisstr.local8Bit(), jakisstr.length());


	}
f.close();
return 0;
}

char *prepare_path(char *filename)
{
	static char path[1023];
	char *home = getenv("HOME");
	struct passwd *pw;

	if (!home) {
		if (!(pw = getpwuid(getuid())))
			return NULL;
		home = pw->pw_dir;
	}
	snprintf(path, sizeof(path), "%s/.gg/%s", home, filename);

	return path;
}

